/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Optional;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrIdsDTO;

public class BrMissedSendungsFolgenDeserializer
implements JsonDeserializer<BrIdsDTO> {
    private static final String JSON_ELEMENT_EDGES = "edges";
    private static final String JSON_ELEMENT_CONTAINER_TODAY = "containerToday";
    private static final String JSON_ELEMENT_BROADCAST_SERVICE = "broadcastService";
    private static final String JSON_ELEMENT_VIEWER = "viewer";
    private static final String JSON_ELEMENT_DATA = "data";
    private static final String JSON_ELEMENT_ID = "id";
    private static final String JSON_ELEMENT_NODE = "node";
    private final MediathekReader crawler;

    public BrMissedSendungsFolgenDeserializer(MediathekReader aCrawler) {
        this.crawler = aCrawler;
    }

    public BrIdsDTO deserialize(JsonElement aElement, Type aType, JsonDeserializationContext aContext) {
        BrIdsDTO results = new BrIdsDTO();
        JsonObject baseObject = aElement.getAsJsonObject();
        Optional<JsonArray> edges = this.getEdges(baseObject);
        if (edges.isPresent()) {
            for (JsonElement edge : edges.get()) {
                JsonObject node;
                JsonObject ebdgeObj = edge.getAsJsonObject();
                if (!ebdgeObj.has(JSON_ELEMENT_NODE) || !(node = ebdgeObj.getAsJsonObject(JSON_ELEMENT_NODE)).has(JSON_ELEMENT_ID)) continue;
                results.add(node.get(JSON_ELEMENT_ID).getAsString());
            }
        }
        return results;
    }

    private Optional<JsonArray> getEdges(JsonObject aBaseObject) {
        if (!aBaseObject.has(JSON_ELEMENT_DATA)) {
            return Optional.empty();
        }
        JsonObject data = aBaseObject.getAsJsonObject(JSON_ELEMENT_DATA);
        if (!data.has(JSON_ELEMENT_VIEWER)) {
            return Optional.empty();
        }
        JsonObject viewer = data.getAsJsonObject(JSON_ELEMENT_VIEWER);
        if (!viewer.has(JSON_ELEMENT_BROADCAST_SERVICE)) {
            return Optional.empty();
        }
        JsonObject broadcastService = viewer.getAsJsonObject(JSON_ELEMENT_BROADCAST_SERVICE);
        if (!broadcastService.has(JSON_ELEMENT_CONTAINER_TODAY)) {
            return Optional.empty();
        }
        JsonObject containerToday = broadcastService.getAsJsonObject(JSON_ELEMENT_CONTAINER_TODAY);
        if (!containerToday.has(JSON_ELEMENT_EDGES)) {
            return Optional.empty();
        }
        return Optional.of(containerToday.getAsJsonArray(JSON_ELEMENT_EDGES));
    }
}

