/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.arte;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import mServer.crawler.sender.arte.ArteJsonObjectToDatenFilmCallable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArteDatenFilmDeserializer
implements JsonDeserializer<ListeFilme> {
    private static final String JSON_ELEMENT_VIDEOS = "videos";
    private static final Logger LOG = LogManager.getLogger(ArteDatenFilmDeserializer.class);
    private final String langCode;
    private final String senderName;

    public ArteDatenFilmDeserializer(String aLangCode, String aSenderName) {
        this.langCode = aLangCode;
        this.senderName = aSenderName;
    }

    public ListeFilme deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        ListeFilme listeFilme = new ListeFilme();
        ArrayList<DatenFilm> futureFilme = new ArrayList<DatenFilm>();
        for (JsonElement jsonElement : aJsonElement.getAsJsonObject().get(JSON_ELEMENT_VIDEOS).getAsJsonArray()) {
            futureFilme.add(new ArteJsonObjectToDatenFilmCallable(jsonElement.getAsJsonObject(), this.langCode, this.senderName).call());
        }
        CopyOnWriteArrayList finishedFilme = new CopyOnWriteArrayList();
        futureFilme.parallelStream().forEach(finishedFilm -> {
            try {
                if (finishedFilm != null) {
                    finishedFilme.add(finishedFilm);
                }
            }
            catch (Exception exception) {
                LOG.error("Es ist ein Fehler beim lesen der Arte Filme aufgetreten.", (Throwable)exception);
            }
        });
        listeFilme.addAll(finishedFilme);
        return listeFilme;
    }
}

