/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.MediathekZdf;
import mServer.tool.MserverDaten;
import org.apache.commons.lang3.time.FastDateFormat;

public class MediathekZdfTivi
extends MediathekReader {
    public static final String SENDERNAME = "ZDF-tivi";
    private final SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final FastDateFormat sdfOut_date = FastDateFormat.getInstance((String)"dd.MM.yyyy");
    private final FastDateFormat sdfOut_time = FastDateFormat.getInstance((String)"HH:mm:ss");
    private final MediathekReader.LinkedListUrl listeThemen_3 = new MediathekReader.LinkedListUrl();

    public MediathekZdfTivi(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 50, startPrio);
    }

    @Override
    public synchronized void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.add_1();
        this.add_2();
        this.add_3();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeThemen_3.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeThemen_3.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void add_1() {
        String MUSTER_URL = "<ns3:page>/tiviVideos";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seiteTivi_1 = getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/rueckblick?view=flashXml", StandardCharsets.UTF_8, 6, seiteTivi_1, "");
        if (seiteTivi_1.length() == 0) {
            Log.errorLog((int)732323698, (String)"Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("<ns3:page>/tiviVideos", pos)) != -1) {
                String url = "";
                int pos1 = pos += "<ns3:page>/tiviVideos".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)309075109, (String)"keine URL");
                    continue;
                }
                url = "http://www.tivi.de/tiviVideos" + url;
                this.listeThemen.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)302010498, (Exception)ex);
        }
    }

    private void add_2() {
        String MUSTER_URL = "<ns3:page>/tiviVideos/beitrag";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seiteTivi_1 = getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/?view=flashXml", StandardCharsets.UTF_8, 6, seiteTivi_1, "");
        if (seiteTivi_1.length() == 0) {
            Log.errorLog((int)645121326, (String)"Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("<ns3:page>/tiviVideos/beitrag", pos)) != -1) {
                String url = "";
                int pos1 = pos += "<ns3:page>/tiviVideos/beitrag".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)915263985, (String)"keine URL");
                    continue;
                }
                url = "http://www.tivi.de/tiviVideos/beitrag" + url;
                this.listeThemen.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)730169702, (Exception)ex);
        }
    }

    private void add_3() {
        String MUSTER_URL = "type=\"broadcast\">";
        MSStringBuilder seiteTivi_1 = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seiteTivi_1 = getUrlIo.getUri(SENDERNAME, "http://www.tivi.de/tiviVideos/navigation?view=flashXml", StandardCharsets.UTF_8, 6, seiteTivi_1, "");
        if (seiteTivi_1.length() == 0) {
            Log.errorLog((int)195623078, (String)"Leere Seite");
        }
        int pos = 0;
        try {
            while ((pos = seiteTivi_1.indexOf("type=\"broadcast\">", pos)) != -1) {
                String url = "";
                int pos1 = pos += "type=\"broadcast\">".length();
                int pos2 = seiteTivi_1.indexOf("<", pos1);
                if (pos2 != -1 && (url = seiteTivi_1.substring(pos1, pos2)).contains("%2F")) {
                    url = url.replace("%2F", "/");
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)152378787, (String)"keine URL");
                    continue;
                }
                url = "http://www.tivi.de" + url;
                this.listeThemen_3.addUrl(new String[]{url});
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)906037912, (Exception)ex);
        }
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekZdfTivi.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekZdfTivi.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekZdfTivi.this.listeThemen.getListeThemen()) != null) {
                    this.addTivi_(link[0]);
                    MediathekZdfTivi.this.meldungProgress(link[0]);
                }
                while (!Config.getStop() && (link = MediathekZdfTivi.this.listeThemen_3.getListeThemen()) != null) {
                    this.add_(link[0]);
                    MediathekZdfTivi.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)731214569, (Exception)ex);
            }
            MediathekZdfTivi.this.meldungThreadUndFertig();
        }

        private void add_(String url_) {
            String MUSTER_START = "<ns3:video-teaser>";
            GetUrl getUrlIo = new GetUrl(MediathekZdfTivi.this.getWartenSeiteLaden());
            this.seite2 = getUrlIo.getUri(MediathekZdfTivi.SENDERNAME, url_, StandardCharsets.UTF_8, 1, this.seite2, "");
            if (this.seite2.length() == 0) {
                Log.errorLog((int)302010698, (String)"Leere Seite");
            }
            int pos = 0;
            try {
                while (!Config.getStop() && (pos = this.seite2.indexOf("<ns3:video-teaser>", pos)) != -1) {
                    String url = this.seite2.extract("<ns3:page>", "<", pos += "<ns3:video-teaser>".length());
                    if (url.isEmpty()) {
                        Log.errorLog((int)732698720, (String)"keine URL");
                        continue;
                    }
                    if (url.contains("%2F")) {
                        url = url.replace("%2F", "/");
                    }
                    url = "http://www.tivi.de" + url;
                    this.addTivi_(url);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)701212145, (Exception)ex);
            }
        }

        private void addTivi_(String url) {
            try {
                String datum;
                String zeit;
                long dauerL;
                String website;
                String text;
                String titel;
                String thema;
                String urlFilm;
                block11: {
                    urlFilm = "";
                    MediathekZdfTivi.this.meldung(url);
                    this.seite1 = this.getUrl.getUri_Utf(MediathekZdfTivi.SENDERNAME, url, this.seite1, "");
                    if (this.seite1.length() == 0) {
                        Log.errorLog((int)301649897, (String)("Leere Seite Tivi-2: " + url));
                        return;
                    }
                    thema = this.seite1.extract("<title>", "<");
                    titel = this.seite1.extract("<subtitle>", "<");
                    text = this.seite1.extract("<text>", "<");
                    String bild = this.seite1.extract("<image>", "<");
                    if (!bild.isEmpty()) {
                        bild = "http://www.tivi.de" + bild;
                    }
                    website = this.seite1.extract("<link>", "<");
                    dauerL = this.parseDauer(this.seite1, url);
                    zeit = "";
                    datum = this.seite1.extract("<airTime>", "<");
                    if (!datum.isEmpty()) {
                        try {
                            Date filmDate = MediathekZdfTivi.this.sdfIn.parse(datum);
                            datum = MediathekZdfTivi.this.sdfOut_date.format(filmDate);
                            zeit = MediathekZdfTivi.this.sdfOut_time.format(filmDate);
                        }
                        catch (NumberFormatException ex) {
                            if (!MserverDaten.debug) break block11;
                            Log.errorLog((int)649600299, (Exception)ex, (String)("Datum: " + url));
                        }
                    }
                }
                int pos3 = 0;
                while (!((pos3 = this.seite1.indexOf("<ns4:quality>veryhigh</ns4:quality>", pos3)) == -1 || (urlFilm = this.seite1.extract("<ns4:url>", "<", pos3 += 5)).startsWith("http") && urlFilm.endsWith("mp4") && !urlFilm.contains("metafilegenerator"))) {
                }
                if (urlFilm.isEmpty()) {
                    Log.errorLog((int)159876234, (String)("kein Film: " + url));
                } else {
                    if (urlFilm.startsWith("http://tvdl.zdf.de")) {
                        urlFilm = urlFilm.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                    }
                    DatenFilm film = new DatenFilm(MediathekZdfTivi.SENDERNAME, thema, website, titel, urlFilm, "", datum, zeit, dauerL, text);
                    MediathekZdf.urlTauschen(film, url, MediathekZdfTivi.this.mlibFilmeSuchen);
                    MediathekZdfTivi.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)454123698, (Exception)ex);
            }
        }

        private long parseDauer(MSStringBuilder seite, String url) {
            long dauer = 0L;
            try {
                String duration = seite.extract("<duration>", "<");
                if (!duration.isEmpty()) {
                    dauer = this.parseDuration(duration);
                }
                if (dauer == 0L) {
                    String length = seite.extract("<lengthSec>", "<");
                    dauer = Integer.parseInt(length);
                }
            }
            catch (NumberFormatException ex) {
                Log.errorLog((int)349761012, (Exception)ex, (String)("Dauer: " + url));
            }
            return dauer;
        }

        private long parseDuration(String duration) {
            String time = duration.replace("P0Y0M0DT", "");
            String h = time.substring(0, time.indexOf(72));
            int ih = Integer.parseInt(h);
            String m = time.substring(time.indexOf(72) + 1, time.indexOf(77));
            int im = Integer.parseInt(m);
            String s = time.substring(time.indexOf(77) + 1, time.indexOf(46));
            int is = Integer.parseInt(s);
            return ih * 60 * 60 + im * 60 + is;
        }
    }
}

