/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;

public class MediathekSrfPod
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "SRF.Podcast";
    private MSStringBuilder seite = new MSStringBuilder(65536);

    public MediathekSrfPod(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 200, startPrio);
    }

    @Override
    public void addToList() {
        String[] add;
        int pos2;
        int pos1;
        String MUSTER_1 = "value=\"http://feeds.sf.tv/podcast";
        String MUSTER_2 = "value=\"http://pod.drs.ch/";
        String addr1 = "http://www.srf.ch/podcasts";
        this.listeThemen.clear();
        this.meldungStart();
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        this.seite = getUrlIo.getUri_Utf(SENDERNAME, addr1, this.seite, "");
        int pos = 0;
        String url = "";
        while (!Config.getStop() && (pos = this.seite.indexOf("value=\"http://feeds.sf.tv/podcast", pos)) != -1) {
            pos1 = pos += "value=\"http://feeds.sf.tv/podcast".length();
            pos2 = this.seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = this.seite.substring(pos1, pos2);
                url = "http://feeds.sf.tv/podcast" + url;
            }
            if (url.isEmpty()) {
                Log.errorLog((int)698875503, (String)"keine URL");
                continue;
            }
            add = new String[]{url, ""};
            this.listeThemen.addUrl(add);
        }
        pos = 0;
        while (!Config.getStop() && (pos = this.seite.indexOf("value=\"http://pod.drs.ch/", pos)) != -1) {
            pos1 = pos += "value=\"http://pod.drs.ch/".length();
            pos2 = this.seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = this.seite.substring(pos1, pos2);
                url = "http://pod.drs.ch/" + url;
            }
            if (url.isEmpty()) {
                Log.errorLog((int)698875503, (String)"keine URL");
                continue;
            }
            add = new String[]{url, ""};
            this.listeThemen.addUrl(add);
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private String convertDatum(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.errorLog((int)649600299, (Exception)ex);
        }
        return datum;
    }

    private String convertTime(String zeit) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(zeit);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            zeit = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.errorLog((int)663259004, (Exception)ex);
        }
        return zeit;
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekSrfPod.this.getWartenSeiteLaden());
            this.seite = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekSrfPod.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekSrfPod.this.listeThemen.getListeThemen()) != null) {
                    MediathekSrfPod.this.meldungProgress(link[0]);
                    this.addFilme(link[1], link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)286931004, (Exception)ex);
            }
            MediathekSrfPod.this.meldungThreadUndFertig();
        }

        private void addFilme(String thema, String strUrlFeed) {
            String MUSTER_THEMA_1 = "<title>";
            String MUSTER_THEMA_2 = "</title>";
            String MUSTER_URL_1 = "url=\"http://";
            String MUSTER_DATE = "<pubDate>";
            String MUSTER_DURATION = "<itunes:duration>";
            String MUSTER_DESCRIPTION = "<itunes:summary>";
            String MUSTER_IMAGE = "<itunes:image href=\"";
            String MUSTER_KEYWORDS = "<itunes:keywords>";
            int pos = 0;
            String url = "";
            long duration = 0L;
            String description = "";
            String image = "";
            try {
                int pos4;
                int pos3;
                int pos2;
                MediathekSrfPod.this.meldung(strUrlFeed);
                this.seite = this.getUrl.getUri_Utf(MediathekSrfPod.SENDERNAME, strUrlFeed, this.seite, "Thema: " + thema);
                int pos1 = this.seite.indexOf("<title>");
                if (pos1 != -1) {
                    pos1 += "<title>".length();
                }
                if ((pos2 = this.seite.indexOf("</title>", pos1)) != -1) {
                    thema = this.seite.substring(pos1, pos2).trim();
                }
                if ((pos3 = this.seite.indexOf("<itunes:image href=\"")) != -1 && (pos4 = this.seite.indexOf("\"", pos3 += "<itunes:image href=\"".length())) != -1) {
                    image = this.seite.substring(pos3, pos4);
                }
                while ((pos = this.seite.indexOf("<title>", pos)) != -1) {
                    int p2;
                    String k;
                    pos1 = pos += "<title>".length();
                    String d = "";
                    int pos5 = this.seite.indexOf("<itunes:duration>", pos);
                    if (pos5 != -1 && (pos2 = this.seite.indexOf("</", pos5 += "<itunes:duration>".length())) != -1 && !(d = this.seite.substring(pos5, pos2)).isEmpty()) {
                        try {
                            if (d.contains(".")) {
                                d = d.replace(".", "");
                                duration = Long.parseLong(d);
                                duration /= 1000L;
                            } else if (d.contains(":")) {
                                duration = 0L;
                                String[] parts = d.split(":");
                                long power = 1L;
                                for (int i = parts.length - 1; i >= 0; --i) {
                                    duration += Long.parseLong(parts[i]) * power;
                                    power *= 60L;
                                }
                            } else {
                                duration = Long.parseLong(d);
                            }
                        }
                        catch (Exception ex) {
                            Log.errorLog((int)915263987, (String)("d: " + d));
                        }
                    }
                    if (duration == 0L && !d.equals("0")) {
                        Log.errorLog((int)915159637, (String)"keine Dauer");
                    }
                    if ((pos5 = this.seite.indexOf("<itunes:summary>", pos)) != -1 && (pos2 = this.seite.indexOf("</", pos5 += "<itunes:summary>".length())) != -1) {
                        description = this.seite.substring(pos5, pos2);
                    }
                    if ((pos5 = this.seite.indexOf("<itunes:keywords>", pos)) != -1 && (pos2 = this.seite.indexOf("</", pos5 += "<itunes:keywords>".length())) != -1 && !(k = this.seite.substring(pos5, pos2)).isEmpty()) {
                        String[] keywords = k.split(",");
                        for (int i = 0; i < keywords.length; ++i) {
                            keywords[i] = keywords[i].trim();
                        }
                    }
                    if ((pos2 = this.seite.indexOf("</title>", pos1)) == -1) continue;
                    String titel = this.seite.substring(pos1, pos2).trim();
                    String datum = "";
                    String zeit = "";
                    int p1 = this.seite.indexOf("<pubDate>", pos1);
                    if (p1 != -1 && (p2 = this.seite.indexOf("<", p1 += "<pubDate>".length())) != -1) {
                        String tmp = this.seite.substring(p1, p2);
                        datum = MediathekSrfPod.this.convertDatum(tmp);
                        zeit = MediathekSrfPod.this.convertTime(tmp);
                    }
                    if ((pos1 = this.seite.indexOf("url=\"http://", pos1)) == -1) continue;
                    pos2 = this.seite.indexOf("\"", pos1 += "url=\"http://".length());
                    if (pos2 != -1) {
                        url = this.seite.substring(pos1, pos2);
                        url = "http://" + url;
                    }
                    if (url.isEmpty()) {
                        Log.errorLog((int)463820049, (String)("keine URL: " + strUrlFeed));
                        continue;
                    }
                    MediathekSrfPod.this.addFilm(new DatenFilm(MediathekSrfPod.SENDERNAME, thema, strUrlFeed, titel, url, "", datum, zeit, duration, description));
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)496352007, (Exception)ex);
            }
        }
    }
}

