/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;

public class MediathekPhoenix
extends MediathekReader {
    public static final String SENDERNAME = "PHOENIX";
    private MSStringBuilder seite = new MSStringBuilder(65536);

    public MediathekPhoenix(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 100, startPrio);
    }

    @Override
    public void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.addToList_();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addToList_() {
        String MUSTER = "<li><strong><a href=\"/content/";
        GetUrl getUrl = new GetUrl(this.getWartenSeiteLaden());
        this.seite = getUrl.getUri(SENDERNAME, "http://www.phoenix.de/content/78905", StandardCharsets.ISO_8859_1, 6, this.seite, "");
        if (this.seite.length() == 0) {
            Log.errorLog((int)487512369, (String)"Leere Seite f\u00fcr URL: ");
        }
        int pos = 0;
        while ((pos = this.seite.indexOf("<li><strong><a href=\"/content/", pos)) != -1) {
            String url;
            int pos1 = pos += "<li><strong><a href=\"/content/".length();
            int pos2 = this.seite.indexOf("\"", pos);
            if (pos2 == -1 || (url = this.seite.substring(pos1, pos2)).isEmpty()) continue;
            url = "http://www.phoenix.de/content/" + url;
            String thema = this.seite.extract(">", "<", pos);
            thema = thema.replace("\"", "");
            this.listeThemen.addUrl(new String[]{url, thema});
        }
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite3;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekPhoenix.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekPhoenix.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekPhoenix.this.listeThemen.getListeThemen()) != null) {
                    this.seite1.setLength(0);
                    this.addFilme1(link[0], link[1]);
                    MediathekPhoenix.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)825263641, (Exception)ex);
            }
            MediathekPhoenix.this.meldungThreadUndFertig();
        }

        private void addFilme1(String url, String thema) {
            try {
                this.getUrl.getUri_Iso(MediathekPhoenix.SENDERNAME, url, this.seite1, "Thema: " + thema);
                ArrayList liste = new ArrayList();
                this.seite1.extractList("<div class=\"linkliste2\">", "", "<li><a href=\"/content/", "\"", "http://www.phoenix.de/content/", liste);
                for (String urlThema : liste) {
                    if (!Config.getStop()) {
                        MediathekPhoenix.this.meldung(urlThema);
                        this.addFilme2(thema, urlThema);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)741258410, (Exception)ex, (String)url);
            }
        }

        private void addFilme2(String thema, String filmWebsite) {
            this.getUrl.getUri_Iso(MediathekPhoenix.SENDERNAME, filmWebsite, this.seite1, "");
            String urlId = this.seite1.extract("\"content\":\"", "", "\"", 0, 0, "http://www.phoenix.de/php/mediaplayer/data/beitrags_details.php?ak=web&id=");
            String title = this.seite1.extract("<title>", "<");
            title = title.replace("phoenix  -", "").trim();
            if (!urlId.isEmpty()) {
                this.filmHolenId(thema, filmWebsite, urlId, title);
            } else {
                Log.errorLog((int)912546987, (String)filmWebsite);
            }
        }

        private void filmHolenId(String thema, String filmWebsite, String urlId, String title_) {
            int pos1;
            int posEnde;
            String beschreibung;
            if (Config.getStop()) {
                return;
            }
            MediathekPhoenix.this.meldung(urlId);
            this.getUrl.getUri_Utf(MediathekPhoenix.SENDERNAME, urlId, this.seite3, "");
            if (this.seite3.length() == 0) {
                Log.errorLog((int)825412874, (String)("url: " + urlId));
                return;
            }
            String titel = this.seite3.extract("<title>", "<");
            if (titel.isEmpty()) {
                titel = title_;
            }
            if ((titel = titel.replaceAll("\u0096", "-")).startsWith("\"") && titel.endsWith("\"")) {
                titel = titel.substring(1, titel.length() - 2);
            }
            if ((beschreibung = this.seite3.extract("<detail>", "<")).startsWith(titel)) {
                beschreibung = beschreibung.replaceFirst(titel, "");
            }
            beschreibung = beschreibung.replaceAll("\n", "");
            beschreibung = beschreibung.replaceAll("\u0096", "-");
            String laenge = this.seite3.extract("<lengthSec>", "<");
            String datum = this.seite3.extract("<airtime>", "<");
            if (datum.startsWith("01.01.1970")) {
                datum = this.seite3.extract("<onlineairtime>", "<");
            }
            String zeit = "";
            if (datum.contains(" ")) {
                zeit = datum.substring(datum.lastIndexOf(32)).trim() + ":00";
                datum = datum.substring(0, datum.lastIndexOf(32)).trim();
            }
            String url = "";
            String urlKlein = "";
            String urlHd = "";
            int posAnfang = 0;
            String URL_ANFANG = "<formitaet basetype=\"h264_aac_mp4_http_na_na\"";
            String URL_ENDE = "</formitaet>";
            String URL2 = "<url>";
            String URL_ANFANG_HD = "<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"";
            while ((posAnfang = this.seite3.indexOf("<formitaet basetype=\"h264_aac_mp4_http_na_na\"", posAnfang)) != -1 && (posEnde = this.seite3.indexOf("</formitaet>", posAnfang += "<formitaet basetype=\"h264_aac_mp4_http_na_na\"".length())) != -1) {
                pos1 = this.seite3.indexOf("<quality>high</quality>", posAnfang);
                if (pos1 != -1 && pos1 < posEnde) {
                    if (!urlKlein.isEmpty() && !urlKlein.contains("metafilegenerator")) continue;
                    urlKlein = this.seite3.extract("<url>", "<", posAnfang, posEnde);
                }
                if ((pos1 = this.seite3.indexOf("<quality>veryhigh</quality>", posAnfang)) == -1 || pos1 >= posEnde || !url.isEmpty() && !url.contains("metafilegenerator") && !url.contains("podfiles")) continue;
                url = this.seite3.extract("<url>", "<", posAnfang, posEnde);
            }
            posAnfang = 0;
            while ((posAnfang = this.seite3.indexOf("<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"", posAnfang)) != -1 && (posEnde = this.seite3.indexOf("</formitaet>", posAnfang += "<formitaet basetype=\"wmv3_wma9_asf_mms_asx_http\"".length())) != -1 && ((pos1 = this.seite3.indexOf("<quality>hd</quality>", posAnfang)) == -1 || pos1 <= posEnde && (urlHd = this.seite3.extract("<url>", "<", posAnfang, posEnde)).isEmpty())) {
            }
            if (url.isEmpty() && !urlKlein.isEmpty()) {
                url = urlKlein;
                urlKlein = "";
            }
            if (url.isEmpty()) {
                Log.errorLog((int)952102014, (String)("keine URL: " + filmWebsite));
            } else {
                if (url.startsWith("http://tvdl.zdf.de")) {
                    url = url.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                if (urlKlein.startsWith("http://tvdl.zdf.de")) {
                    urlKlein = urlKlein.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                if (urlHd.startsWith("http://tvdl.zdf.de")) {
                    urlHd = url.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
                }
                DatenFilm film = new DatenFilm(MediathekPhoenix.SENDERNAME, thema, filmWebsite, titel, url, "", datum, zeit, MediathekReader.extractDuration(laenge), beschreibung);
                MediathekPhoenix.this.addFilm(film);
                CrawlerTool.addUrlKlein(film, urlKlein, "");
                CrawlerTool.addUrlHd(film, urlHd, "");
            }
        }
    }
}

