/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.tool.MserverDaten;
import org.apache.commons.lang3.time.FastDateFormat;

public class MediathekKika
extends MediathekReader {
    public static final String SENDERNAME = "KiKA";
    private final MediathekReader.HashSetUrl listeAllVideos = new MediathekReader.HashSetUrl();
    private MSStringBuilder seite = new MSStringBuilder(65536);

    public MediathekKika(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 16, 50, startPrio);
        this.setName("MediathekKiKa");
    }

    @Override
    protected void addToList() {
        this.meldungStart();
        if (CrawlerTool.loadLongMax()) {
            this.addToListNormal();
        }
        this.addToListAllVideo();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeAllVideos.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeAllVideos.size());
            for (int t = 0; t <= this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addToListNormal() {
        EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa.addToListNormal");
        String ADRESSE = "http://www.kika.de/sendungen/sendungenabisz100.html";
        String MUSTER_URL = "<a href=\"/sendungen/sendungenabisz100_";
        ArrayList liste1 = new ArrayList();
        ArrayList liste2 = new ArrayList();
        this.listeThemen.clear();
        try {
            GetUrl getUrl = new GetUrl(this.getWartenSeiteLaden());
            this.seite = getUrl.getUri(SENDERNAME, "http://www.kika.de/sendungen/sendungenabisz100.html", StandardCharsets.UTF_8, 3, this.seite, "KiKA: Startseite");
            this.seite.extractList("", "", "<a href=\"/sendungen/sendungenabisz100_", "\"", "http://www.kika.de/sendungen/sendungenabisz100_", liste1);
            for (String s : liste1) {
                this.seite = getUrl.getUri_Utf(this.getSendername(), s, this.seite, "KiKa-Sendungen");
                String MUSTER_SENDUNGEN_1 = "<h4 class=\"headline\">";
                String MUSTER_SENDUNGEN_2 = "<a href=\"/";
                this.seite.extractList("", "<!--The bottom navigation -->", "<h4 class=\"headline\">", "<a href=\"/", "\"", "http://www.kika.de/", liste2);
            }
            for (String ss : liste2) {
                this.listeThemen.add(new String[]{ss});
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)302025469, (Exception)ex);
        }
        performancePoint.collect();
    }

    private void addToListAllVideo() {
        EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa.addToListAllVideo");
        String ADRESSE = "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100.html";
        String MUSTER_URL = "<a href=\"/videos/allevideos/allevideos-buendelgruppen100_page-";
        ArrayList liste1 = new ArrayList();
        ArrayList liste2 = new ArrayList();
        try {
            GetUrl getUrl = new GetUrl(this.getWartenSeiteLaden());
            this.seite = getUrl.getUri(SENDERNAME, "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100.html", StandardCharsets.UTF_8, 3, this.seite, "KiKA: Startseite alle Videos");
            this.seite.extractList("", "", "<a href=\"/videos/allevideos/allevideos-buendelgruppen100_page-", "\"", "http://www.kika.de/videos/allevideos/allevideos-buendelgruppen100_page-", liste1);
            for (String s1 : liste1) {
                this.seite = getUrl.getUri_Utf(this.getSendername(), s1, this.seite, "KiKa-Sendungen");
                this.seite.extractList("", "", "<div class=\"media mediaA\">\n<a href=\"/", "\"", "http://www.kika.de/", liste2);
            }
            for (String s2 : liste2) {
                this.listeAllVideos.add(new String[]{s2});
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)732120256, (Exception)ex);
        }
        performancePoint.collect();
    }

    private class ThemaLaden
    extends Thread {
        private final ArrayList<String> liste1 = new ArrayList();
        private final ArrayList<String> liste2 = new ArrayList();
        private MSStringBuilder seite1 = new MSStringBuilder(65536);
        private MSStringBuilder seite2 = new MSStringBuilder(65536);
        private MSStringBuilder seite3 = new MSStringBuilder(65536);
        private final FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

        private ThemaLaden() {
        }

        @Override
        public void run() {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.run");
            try {
                String[] link;
                MediathekKika.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekKika.this.listeAllVideos.getListeThemen()) != null) {
                    MediathekKika.this.meldungProgress(link[0]);
                    this.loadAllVideo_1(link[0]);
                }
                while (!Config.getStop() && (link = MediathekKika.this.listeThemen.getListeThemen()) != null) {
                    MediathekKika.this.meldungProgress(link[0]);
                    this.ladenSerien_1(link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)915236791, (Exception)ex);
            }
            MediathekKika.this.meldungThreadUndFertig();
            performancePoint.collect();
        }

        private void ladenSerien_1(String filmWebsite) {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.ladenSerien_1");
            try {
                this.liste1.clear();
                this.liste2.clear();
                GetUrl getUrl = new GetUrl(MediathekKika.this.getWartenSeiteLaden());
                this.seite1 = getUrl.getUri(MediathekKika.SENDERNAME, filmWebsite, StandardCharsets.UTF_8, 1, this.seite1, "Themenseite");
                String thema = this.seite1.extract("<title>", "<");
                thema = thema.replace("KiKA -", "").trim();
                String url = "";
                if (url.isEmpty()) {
                    url = this.seite1.extract("<h2 class=\"conHeadline\">Alle Folgen</h2>", "<a href=\"", "\"");
                }
                if (url.isEmpty()) {
                    url = this.seite1.extract("<h2 class=\"conHeadline\">Alle Sendungen</h2>", "<a href=\"", "\"");
                }
                if (url.isEmpty()) {
                    int p = this.seite1.indexOf("<h2 class=\"conHeadline\">N\u00e4chste Folge</h2>");
                    if (p <= 0) {
                        p = 0;
                    }
                    url = this.seite1.extract("<span class=\"moreBtn\">", "<a href=\"", "\"", p, 0, "");
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)721356987, (String)("keine URL: " + filmWebsite));
                    return;
                }
                if (!url.startsWith("http://www.kika.de")) {
                    url = "http://www.kika.de" + url;
                }
                this.seite1 = getUrl.getUri(MediathekKika.SENDERNAME, url, StandardCharsets.UTF_8, 1, this.seite1, "Themenseite");
                this.seite1.extractList("", "<!--The bottom navigation -->", "<div class=\"shortInfos\">", "<a href=\"", "\"", "http://www.kika.de", this.liste1);
                this.seite1.extractList("", "", "<div class=\"bundleNaviItem \">", "<a href=\"", "\"", "http://www.kika.de", this.liste2);
                for (String s : this.liste2) {
                    this.seite1 = getUrl.getUri(MediathekKika.SENDERNAME, s, StandardCharsets.UTF_8, 1, this.seite1, "Themenseite");
                    this.seite1.extractList("", "<!--The bottom navigation -->", "<div class=\"shortInfos\">", "<a href=\"", "\"", "http://www.kika.de", this.liste1);
                }
                if (this.liste1.isEmpty()) {
                    Log.errorLog((int)794512630, (String)("keine Filme: " + filmWebsite));
                    return;
                }
                int count = 0;
                int err = 0;
                for (int i = this.liste1.size() - 1; i >= 0; --i) {
                    String s = this.liste1.get(i);
                    if (!CrawlerTool.loadLongMax() && ++count > 4) {
                        return;
                    }
                    if (Config.getStop()) {
                        return;
                    }
                    if (!this.ladenSerien_2(s, thema)) {
                        if (CrawlerTool.loadLongMax() || ++err <= 2) continue;
                        break;
                    }
                    err = 0;
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)915263147, (Exception)ex);
            }
            performancePoint.collect();
        }

        private boolean ladenSerien_2(String filmWebsite, String thema) {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.ladenSerien_2");
            boolean ret = false;
            try {
                MediathekKika.this.meldung(filmWebsite);
                GetUrl getUrl = new GetUrl(MediathekKika.this.getWartenSeiteLaden());
                this.seite1 = getUrl.getUri(MediathekKika.SENDERNAME, filmWebsite, StandardCharsets.UTF_8, 1, this.seite1, "Themenseite");
                String xml = this.seite1.extract("<div class=\"av-playerContainer\"", "setup({dataURL:'", "'");
                if (!xml.isEmpty()) {
                    ret = true;
                    this.ladenXml(xml, thema, false);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)801202145, (Exception)ex);
            }
            performancePoint.collect();
            return ret;
        }

        private void loadAllVideo_1(String url) {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.loadAllVideo_1");
            ArrayList liste = new ArrayList();
            try {
                GetUrl getUrl = new GetUrl(MediathekKika.this.getWartenSeiteLaden());
                this.seite2 = getUrl.getUri(MediathekKika.this.getSendername(), url, StandardCharsets.UTF_8, 1, this.seite2, "KiKa-Sendungen");
                String urlPartSendung = this.getUrlPartSendung(url);
                this.loadAllVideo_2(this.seite2, urlPartSendung);
                if (CrawlerTool.loadLongMax()) {
                    this.seite2.extractList("", "", "<div class=\"bundleNaviItem active\">\n<a href=\"/videos/allevideos/", "\"", "http://www.kika.de/videos/allevideos/", liste);
                    this.seite2.extractList("", "", "<div class=\"bundleNaviItem \">\n<a href=\"/videos/allevideos/", "\"", "http://www.kika.de/videos/allevideos/", liste);
                }
                for (String u : liste) {
                    if (!Config.getStop()) {
                        this.seite2 = getUrl.getUri(MediathekKika.this.getSendername(), u, StandardCharsets.UTF_8, 1, this.seite2, "KiKa-Sendungen");
                        this.loadAllVideo_2(this.seite2, urlPartSendung);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)825412369, (Exception)ex);
            }
            performancePoint.collect();
        }

        private String getUrlPartSendung(String url) {
            String[] parts = url.split("/");
            String urlPartSendung = parts[3];
            return urlPartSendung;
        }

        private void loadAllVideo_2(MSStringBuilder sStringBuilder, String urlPartSendung) {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.loadAllVideo_2");
            ArrayList liste = new ArrayList();
            try {
                String thema = sStringBuilder.extract("<h1 class=\"headline\">", "<").trim();
                if (thema.isEmpty()) {
                    thema = sStringBuilder.extract("<title>KiKA -", "<").trim();
                }
                sStringBuilder.extractList(".setup({dataURL:'", "'", liste);
                for (String s : liste) {
                    if (!Config.getStop() && s.contains(urlPartSendung)) {
                        this.ladenXml(s, thema, true);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)201036987, (Exception)ex);
            }
            performancePoint.collect();
        }

        private void ladenXml(String xmlWebsite, String thema, boolean urlPruefen) {
            EtmPoint performancePoint = EtmManager.getEtmMonitor().createPoint("MediathekKiKa::ThemaLaden.ladenXml");
            try {
                long duration;
                String urlSendung;
                String zeit;
                String datum;
                String date;
                String beschreibung;
                String titel;
                block19: {
                    GetUrl getUrl = new GetUrl(MediathekKika.this.getWartenSeiteLaden());
                    this.seite3 = getUrl.getUri(MediathekKika.this.getSendername(), xmlWebsite, StandardCharsets.UTF_8, 1, this.seite3, "");
                    if (thema.isEmpty()) {
                        thema = MediathekKika.this.getSendername();
                    }
                    if (thema.equals("ABC-B\u00e4r")) {
                        thema = "ABC B\u00e4r";
                    }
                    if ((titel = this.seite3.extract("<title>", "<")).toLowerCase().equals(thema.toLowerCase())) {
                        titel = this.seite3.extract("<headline>", "<");
                    }
                    if (titel.toLowerCase().equals(thema.toLowerCase()) && (titel = this.seite3.extract("<topline>", "<")).isEmpty()) {
                        titel = this.seite3.extract("<title>", "<");
                    }
                    beschreibung = this.seite3.extract("<broadcastDescription>", "<");
                    date = this.seite3.extract("<broadcastDate>", "<");
                    datum = "";
                    zeit = "";
                    if (!date.isEmpty()) {
                        datum = this.convertDatum(date);
                        zeit = this.convertTime(date);
                    } else {
                        date = this.seite3.extract("<webTime>", "<");
                        if (!date.isEmpty()) {
                            datum = date.substring(0, date.indexOf(32)).trim();
                            zeit = date.substring(date.indexOf(32)).trim() + ":00";
                        }
                    }
                    urlSendung = this.seite3.extract("<broadcastURL>", "<");
                    if (urlSendung.isEmpty()) {
                        urlSendung = this.seite3.extract("<htmlUrl>", "<");
                    }
                    duration = 0L;
                    long runtime = 0L;
                    try {
                        String dauer = this.seite3.extract("<duration>", "<");
                        if (!dauer.isEmpty()) {
                            String[] parts = dauer.split(":");
                            long power = 1L;
                            for (int i = parts.length - 1; i >= 0; --i) {
                                duration += Long.parseLong(parts[i]) * power;
                                power *= 60L;
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (!MserverDaten.debug) break block19;
                        Log.errorLog((int)201036547, (Exception)ex, (String)xmlWebsite);
                    }
                }
                String MUSTER_URL_MP4 = "<progressiveDownloadUrl>";
                String urlHD = this.seite3.extract("| MP4 Web XL |", "<progressiveDownloadUrl>", "<");
                String urlMp4 = this.seite3.extract("| MP4 Web L |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = this.seite3.extract("| MP4 Web L+ |", "<progressiveDownloadUrl>", "<");
                }
                String urlMp4_klein = this.seite3.extract("| MP4 Web M |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = urlMp4_klein;
                    urlMp4_klein = "";
                }
                if (thema.isEmpty() || urlSendung.isEmpty() || titel.isEmpty() || urlMp4.isEmpty() || date.isEmpty() || zeit.isEmpty() || duration == 0L) {
                    Log.errorLog((int)735216987, (String)("leer: " + xmlWebsite));
                }
                if (!urlMp4.isEmpty()) {
                    MediathekKika.this.meldung(urlMp4);
                    DatenFilm film = new DatenFilm(MediathekKika.SENDERNAME, thema, urlSendung, titel, urlMp4, "", datum, zeit, duration, beschreibung);
                    CrawlerTool.addUrlKlein(film, urlMp4_klein, "");
                    CrawlerTool.addUrlHd(film, urlHD, "");
                    MediathekKika.this.addFilm(film, urlPruefen);
                } else {
                    Log.errorLog((int)963215478, (String)(" xml: " + xmlWebsite));
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)784512365, (Exception)ex);
            }
            performancePoint.collect();
        }

        private String convertDatum(String datum) {
            try {
                FastDateFormat sdfOutDay = FastDateFormat.getInstance((String)"dd.MM.yyyy");
                Date filmDate = this.sdf.parse(datum);
                datum = sdfOutDay.format(filmDate);
            }
            catch (ParseException ex) {
                Log.errorLog((int)731025789, (Exception)ex, (String)("Datum: " + datum));
            }
            return datum;
        }

        private String convertTime(String zeit) {
            try {
                FastDateFormat sdfOutTime = FastDateFormat.getInstance((String)"HH:mm:ss");
                Date filmDate = this.sdf.parse(zeit);
                zeit = sdfOutTime.format(filmDate);
            }
            catch (ParseException ex) {
                Log.errorLog((int)915423687, (Exception)ex, (String)("Time: " + zeit));
            }
            return zeit;
        }
    }
}

