/*
 * Decompiled with CFR 0.152.
 */
package mServer;

import etm.core.configuration.BasicEtmConfigurator;
import etm.core.configuration.EtmManager;
import etm.core.renderer.MeasurementRenderer;
import etm.core.renderer.SimpleTextRenderer;
import java.awt.EventQueue;
import javafx.application.Application;
import mServer.MServer;
import mServer.crawler.CrawlerTool;
import mServer.crawler.gui.MSG;
import mServer.tool.MserverDaten;
import mServer.tool.MserverDatumZeit;
import mServer.tool.MserverLog;

public class Main {
    public static void main(String[] args) {
        StartupMode state = StartupMode.SERVER;
        BasicEtmConfigurator.configure();
        EtmManager.getEtmMonitor().start();
        if (args != null) {
            block17: for (String s : args) {
                switch (s = s.toLowerCase()) {
                    case "-d": {
                        MserverDaten.debug = true;
                        continue block17;
                    }
                    case "-v": {
                        state = StartupMode.VERSION;
                        continue block17;
                    }
                    case "-gui": {
                        state = StartupMode.GUI;
                    }
                }
            }
        }
        switch (state) {
            case SERVER: {
                try {
                    Main.runServer(args);
                }
                catch (InterruptedException e) {
                    MserverLog.fehlerMeldung(34975920, Main.class.getName(), "startServer", (Exception)e);
                }
                break;
            }
            case VERSION: {
                MserverLog.versionsMeldungen(Main.class.toString());
                System.exit(0);
                break;
            }
            case GUI: {
                EventQueue.invokeLater(() -> {
                    CrawlerTool.startMsg();
                    Application.launch(MSG.class, (String[])args);
                });
            }
        }
        EtmManager.getEtmMonitor().render((MeasurementRenderer)new SimpleTextRenderer());
        EtmManager.getEtmMonitor().stop();
    }

    private static void runServer(String[] ar) throws InterruptedException {
        while (new MServer(ar).starten()) {
            long timeToSleep = (MserverDatumZeit.getSecondsUntilNextDay() + 120L) * 1000L;
            MserverLog.systemMeldung("Schlafenlegen bis zum n\u00e4chsten Tag (" + timeToSleep + "ms)");
            Thread.sleep(timeToSleep);
            MserverLog.systemMeldung("Neustart der Suche");
        }
    }

    private static enum StartupMode {
        SERVER,
        VERSION,
        GUI;

    }
}

