/*
 * Decompiled with CFR 0.152.
 */
package mServer;

import java.io.File;
import mServer.daten.MserverSearchTask;
import mServer.search.MserverSearch;
import mServer.tool.MserverDaten;
import mServer.tool.MserverLog;
import mServer.tool.MserverTimer;
import mServer.tool.MserverXmlLesen;
import mServer.upload.MserverUpload;

public class MServer {
    private MserverSearchTask aktSearchTask = null;
    private boolean suchen = false;
    private MserverSearch mvsSearch;

    public MServer(String[] ar) {
        String pfad = "";
        if (ar != null && ar.length > 0 && !ar[0].startsWith("-") && !(pfad = ar[0]).endsWith(File.separator)) {
            pfad = pfad + File.separator;
        }
        MserverDaten.init();
        MserverDaten.setBasisVerzeichnis(pfad);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            MserverLog.fehlerMeldung(97986523, MServer.class.getName(), new String[]{"Da hat sich ein Thread verabschiedet: " + t.getName(), e.getMessage()});
            e.printStackTrace();
        });
    }

    public boolean isSuchen() {
        return this.suchen;
    }

    public boolean starten() {
        if (!MserverDaten.konfigExistiert()) {
            MserverLog.fehlerMeldung(858589654, MServer.class.getName(), new String[]{"Konfig-Datei existiert nicht", MserverDaten.getKonfigDatei()});
            System.exit(1);
        } else {
            MserverXmlLesen.xmlDatenLesen();
            if (MserverDaten.system[13].equals("1")) {
                MserverDaten.debug = true;
            }
            if (MserverDaten.system[14].equals("1")) {
                MserverDaten.restart = true;
            }
            MserverLog.startMeldungen(this.getClass().getName());
            this.mvsSearch = new MserverSearch();
            MserverTimer timerThread = new MserverTimer(this);
            timerThread.start();
            try {
                timerThread.join();
                if (MserverDaten.restart) {
                    return true;
                }
            }
            catch (InterruptedException e) {
                MserverLog.fehlerMeldung(42, MServer.class.getName(), "Fehler bei thread.join()", (Exception)e);
            }
        }
        return false;
    }

    public void laufen() {
        if (this.aktSearchTask == null) {
            this.aktSearchTask = MserverDaten.listeSuchen.erste();
            if (this.aktSearchTask == null) {
                this.undTschuess();
                return;
            }
            this.aktSearchTask.meldungNaechsterStart();
        }
        if (!this.suchen && this.aktSearchTask.starten()) {
            this.suchen = true;
            this.aktSearchTask.meldungStart();
            this.printStartMessage();
            if (!this.mvsSearch.filmeSuchen(this.aktSearchTask)) {
                this.printErrorMessage();
            } else {
                this.printFinishedMessage();
                this.performUpload();
            }
            this.aktSearchTask = null;
            this.suchen = false;
        }
    }

    private void printStartMessage() {
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("======================================");
        MserverLog.systemMeldung("== Filme suchen ======================");
        MserverLog.systemMeldung("--------------------------------------");
    }

    private void performUpload() {
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("===============================");
        MserverLog.systemMeldung("== Upload =====================");
        MserverUpload.upload(this.aktSearchTask);
        MserverLog.systemMeldung("== Upload beendet =============");
        MserverLog.systemMeldung("-------------------------------");
        MserverLog.systemMeldung("---------------------------------------");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
    }

    private void printFinishedMessage() {
        MserverLog.systemMeldung("== Filme Suchen beendet =======");
        MserverLog.systemMeldung("-------------------------------");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
    }

    private void printErrorMessage() {
        MserverLog.systemMeldung("--------------------------------------");
        MserverLog.systemMeldung("== Fehler beim Filme Suchen ==========");
        MserverLog.systemMeldung("-------------------------------");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
    }

    private void undTschuess() {
        MserverLog.printEndeMeldung();
        Thread.currentThread().interrupt();
    }
}

