/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    protected boolean clockwise;
    private boolean _rotateIcon = true;
    private static Rectangle s_oPaintIconRectangle;
    private static Rectangle s_oPaintTextRectangle;
    private static Rectangle s_oPaintViewRectangle;
    private static Insets s_oPaintViewInsets;

    public VerticalLabelUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    public void paint(Graphics i_oGraphics, JComponent i_oComponent) {
        Icon oIcon;
        JLabel oLabel = (JLabel)i_oComponent;
        String oText = oLabel.getText();
        Icon icon = oIcon = oLabel.isEnabled() ? oLabel.getIcon() : oLabel.getDisabledIcon();
        if (oIcon == null && oText == null) {
            return;
        }
        FontMetrics oFontMetrics = i_oGraphics.getFontMetrics();
        s_oPaintViewInsets = i_oComponent.getInsets(s_oPaintViewInsets);
        VerticalLabelUI.s_oPaintViewRectangle.x = VerticalLabelUI.s_oPaintViewInsets.left;
        VerticalLabelUI.s_oPaintViewRectangle.y = VerticalLabelUI.s_oPaintViewInsets.top;
        VerticalLabelUI.s_oPaintViewRectangle.height = i_oComponent.getWidth() - (VerticalLabelUI.s_oPaintViewInsets.left + VerticalLabelUI.s_oPaintViewInsets.right);
        VerticalLabelUI.s_oPaintViewRectangle.width = i_oComponent.getHeight() - (VerticalLabelUI.s_oPaintViewInsets.top + VerticalLabelUI.s_oPaintViewInsets.bottom);
        VerticalLabelUI.s_oPaintIconRectangle.height = 0;
        VerticalLabelUI.s_oPaintIconRectangle.width = 0;
        VerticalLabelUI.s_oPaintIconRectangle.y = 0;
        VerticalLabelUI.s_oPaintIconRectangle.x = 0;
        VerticalLabelUI.s_oPaintTextRectangle.height = 0;
        VerticalLabelUI.s_oPaintTextRectangle.width = 0;
        VerticalLabelUI.s_oPaintTextRectangle.y = 0;
        VerticalLabelUI.s_oPaintTextRectangle.x = 0;
        String sClippedText = this.layoutCL(oLabel, oFontMetrics, oText, oIcon, s_oPaintViewRectangle, s_oPaintIconRectangle, s_oPaintTextRectangle);
        Graphics2D g2 = (Graphics2D)i_oGraphics;
        AffineTransform oTransform = g2.getTransform();
        if (!this.isRotateIcon() && oIcon != null) {
            oIcon.paintIcon(i_oComponent, i_oGraphics, VerticalLabelUI.s_oPaintIconRectangle.x, VerticalLabelUI.s_oPaintIconRectangle.y);
        }
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -i_oComponent.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-i_oComponent.getHeight(), 0);
        }
        if (this.isRotateIcon() && oIcon != null) {
            oIcon.paintIcon(i_oComponent, i_oGraphics, VerticalLabelUI.s_oPaintIconRectangle.x, VerticalLabelUI.s_oPaintIconRectangle.y);
        }
        if (oText != null) {
            int iTextX = VerticalLabelUI.s_oPaintTextRectangle.x;
            int iTextY = VerticalLabelUI.s_oPaintTextRectangle.y + oFontMetrics.getAscent();
            if (oLabel.isEnabled()) {
                this.paintEnabledText(oLabel, i_oGraphics, sClippedText, iTextX, iTextY);
            } else {
                this.paintDisabledText(oLabel, i_oGraphics, sClippedText, iTextX, iTextY);
            }
        }
        g2.setTransform(oTransform);
    }

    public boolean isRotateIcon() {
        return this._rotateIcon;
    }

    public void setRotateIcon(boolean rotateIcon) {
        this._rotateIcon = rotateIcon;
    }

    static {
        labelUI = new VerticalLabelUI(false);
        s_oPaintIconRectangle = new Rectangle();
        s_oPaintTextRectangle = new Rectangle();
        s_oPaintViewRectangle = new Rectangle();
        s_oPaintViewInsets = new Insets(0, 0, 0, 0);
    }
}

