/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import java.util.ArrayList;
import java.util.List;
import mServer.crawler.sender.wdr.WdrDeserializerBase;
import mServer.crawler.sender.wdr.WdrSendungDto;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WdrLetterPageDeserializer
extends WdrDeserializerBase {
    private static final String QUERY_SENDUNG = "ul.list > li > a";
    private static final String QUERY_TITLE = "span";
    private static final String QUERY_URL_TYPE = "strong";

    public List<WdrSendungDto> deserialize(Document document) {
        ArrayList<WdrSendungDto> list = new ArrayList<WdrSendungDto>();
        Elements sendungenElement = document.select(QUERY_SENDUNG);
        sendungenElement.forEach(sendungElement -> {
            String url = this.getUrl((Element)sendungElement);
            if (!url.isEmpty()) {
                WdrSendungDto dto = new WdrSendungDto();
                dto.setTheme(this.getTheme((Element)sendungElement));
                switch (this.getUrlType((Element)sendungElement)) {
                    case OverviewPage: {
                        dto.addOverviewUrls(url);
                        break;
                    }
                    case VideoPage: {
                        dto.addVideoUrl(url);
                    }
                }
                list.add(dto);
            }
        });
        return list;
    }

    private String getTheme(Element sendungElement) {
        Element titleElement = sendungElement.select(QUERY_TITLE).first();
        if (titleElement != null) {
            return titleElement.text();
        }
        return "";
    }

    private String getUrl(Element sendungElement) {
        String url = sendungElement.attr("href");
        if (!url.isEmpty()) {
            url = this.addDomainIfNecessary(url);
        }
        return url;
    }

    private WdrDeserializerBase.UrlType getUrlType(Element sendungElement) {
        Element typeElement = sendungElement.select(QUERY_URL_TYPE).first();
        if (typeElement != null) {
            switch (typeElement.text()) {
                case "mehr": {
                    return WdrDeserializerBase.UrlType.OverviewPage;
                }
                case "video": {
                    return WdrDeserializerBase.UrlType.VideoPage;
                }
            }
        }
        return WdrDeserializerBase.UrlType.None;
    }
}

