/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Log;
import java.util.concurrent.RecursiveTask;
import mServer.crawler.sender.newsearch.DownloadDTO;
import mServer.crawler.sender.newsearch.VideoDTO;
import mServer.crawler.sender.newsearch.ZDFClient;
import mServer.crawler.sender.newsearch.ZDFDownloadDTODeserializer;
import mServer.crawler.sender.newsearch.ZDFEntryDTO;
import mServer.crawler.sender.newsearch.ZDFVideoDTODeserializer;

public class ZDFEntryTask
extends RecursiveTask<VideoDTO> {
    private static final long serialVersionUID = 1L;
    private final ZDFClient client;
    private final ZDFEntryDTO zdfEntryDTO;
    private final Gson gson;

    public ZDFEntryTask(ZDFEntryDTO aEntryDto) {
        this(aEntryDto, new ZDFClient());
    }

    public ZDFEntryTask(ZDFEntryDTO aEntryDto, ZDFClient zdfClient) {
        this.client = zdfClient;
        this.zdfEntryDTO = aEntryDto;
        this.gson = new GsonBuilder().registerTypeAdapter(VideoDTO.class, (Object)new ZDFVideoDTODeserializer()).registerTypeAdapter(DownloadDTO.class, (Object)new ZDFDownloadDTODeserializer()).create();
    }

    @Override
    protected VideoDTO compute() {
        if (this.zdfEntryDTO == null) {
            return null;
        }
        VideoDTO dto = null;
        if (!Config.getStop()) {
            try {
                String downloadUrl;
                JsonObject baseObjectDownload;
                String infoUrl = this.zdfEntryDTO.getEntryGeneralInformationUrl();
                JsonObject baseObjectInfo = this.client.execute(infoUrl);
                if (baseObjectInfo != null && (dto = (VideoDTO)this.gson.fromJson((JsonElement)baseObjectInfo, VideoDTO.class)) != null && (baseObjectDownload = this.client.execute(downloadUrl = this.zdfEntryDTO.getEntryDownloadInformationUrl())) != null) {
                    DownloadDTO downloadDto = (DownloadDTO)this.gson.fromJson((JsonElement)baseObjectDownload, DownloadDTO.class);
                    dto.setDownloadDto(downloadDto);
                }
            }
            catch (Exception ex) {
                Log.errorLog(496583202, ex, "Exception parsing " + (this.zdfEntryDTO != null ? this.zdfEntryDTO.getEntryGeneralInformationUrl() : ""));
                dto = null;
            }
        }
        return dto;
    }
}

