/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.util.ArrayList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;

public class MediathekSr
extends MediathekReader {
    public static final String SENDERNAME = "SR";

    public MediathekSr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 100, startPrio);
    }

    @Override
    public void addToList() {
        this.meldungStart();
        int maxSeiten = 15;
        if (CrawlerTool.loadLongMax()) {
            maxSeiten = 120;
        }
        for (int i = 1; i < maxSeiten; ++i) {
            String[] add = new String[]{"http://www.sr-mediathek.de/index.php?seite=2&f=v&s=" + i + "&o=d", ""};
            this.listeThemen.add(add);
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private final ArrayList<String> erg;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekSr.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.erg = new ArrayList();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekSr.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekSr.this.listeThemen.getListeThemen()) != null) {
                    MediathekSr.this.meldungProgress(link[0]);
                    this.bearbeiteTage(link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog(951236547, ex);
            }
            MediathekSr.this.meldungThreadUndFertig();
        }

        private void bearbeiteTage(String urlSeite) {
            GetUrl getUrlIo = new GetUrl(MediathekSr.this.getWartenSeiteLaden());
            this.seite1 = getUrlIo.getUri_Utf(MediathekSr.SENDERNAME, urlSeite, this.seite1, "");
            this.seite1.extractList("<h3 class=\"teaser__text__header\">", "<a href=\"index.php?seite=", "\"", this.erg);
            for (String url : this.erg) {
                if (Config.getStop()) break;
                this.addFilme("http://www.sr-mediathek.de/index.php?seite=" + url);
            }
            this.erg.clear();
        }

        private void addFilme(String urlSeite) {
            MediathekSr.this.meldung(urlSeite);
            this.seite2 = this.getUrl.getUri_Utf(MediathekSr.SENDERNAME, urlSeite, this.seite2, "");
            try {
                String thema = MediathekSr.SENDERNAME;
                long duration = 0L;
                String d = this.seite2.extract("| Dauer: ", "|").trim();
                try {
                    if (!d.isEmpty()) {
                        duration = 0L;
                        String[] parts = d.split(":");
                        long power = 1L;
                        for (int i = parts.length - 1; i >= 0; --i) {
                            duration += Long.parseLong(parts[i]) * power;
                            power *= 60L;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.errorLog(732012546, "d: " + d);
                }
                String description = this.seite2.extract("<meta property=\"og:description\" content=\"", "\"");
                String datum = this.seite2.extract("Video | ", "|").trim();
                String titel = this.seite2.extract("<title>", "<");
                if (titel.startsWith("SR-Mediathek.de:")) {
                    titel = titel.replaceFirst("SR-Mediathek.de:", "");
                }
                if (titel.contains(" - ")) {
                    thema = titel.substring(0, titel.indexOf(" - ")).trim();
                    titel = titel.substring(titel.indexOf(" - ") + 3).trim();
                } else if (titel.contains(": ")) {
                    thema = titel.substring(0, titel.indexOf(": ")).trim();
                    titel = titel.substring(titel.indexOf(": ") + 2).trim();
                } else if (titel.contains(" \u2013 ")) {
                    thema = titel.substring(0, titel.indexOf(" \u2013 ")).trim();
                    titel = titel.substring(titel.indexOf(" \u2013 ") + 3).trim();
                } else if (titel.contains("(")) {
                    thema = titel.substring(0, titel.indexOf(40)).trim();
                }
                String subtitle = this.seite2.extract("http_get.utPath", "= '", "'");
                String url = this.seite2.extract("var mediaURLs = ['", "'");
                if (url.isEmpty()) {
                    Log.errorLog(301245789, "keine URL f\u00fcr: " + urlSeite);
                } else {
                    DatenFilm film = new DatenFilm(MediathekSr.SENDERNAME, thema, urlSeite, titel, url, "", datum, "", duration, description);
                    if (!subtitle.isEmpty()) {
                        subtitle = "http://sr-mediathek.sr-online.de/" + subtitle;
                        CrawlerTool.addUrlSubtitle(film, subtitle);
                    }
                    MediathekSr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.errorLog(402583366, ex);
            }
        }
    }
}

