/*
 * Decompiled with CFR 0.152.
 */
package etm.core.monitor;

import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmMonitorSupport;
import etm.core.monitor.EtmPoint;

public class MeasurementPoint
implements EtmPoint {
    private static final long SECOND_MULTIPLIER = 1000L;
    private final EtmMonitorSupport monitor;
    private MeasurementPoint parent = null;
    private String name;
    private long startTime = 0L;
    private long endTime = 0L;
    private long ticks = 0L;
    private long startTimeMillis = 0L;

    public MeasurementPoint(EtmMonitor aMonitor, String aName) {
        this.monitor = (EtmMonitorSupport)aMonitor;
        this.name = aName;
        this.startTimeMillis = System.currentTimeMillis();
        this.monitor.visitPreMeasurement(this);
    }

    public void collect() {
        if (this.name == null) {
            throw new IllegalStateException("A measurement point may not be collected without a proper name.");
        }
        this.monitor.visitPostCollect(this);
    }

    public void alterName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getTicks() {
        return this.ticks;
    }

    protected void setParent(MeasurementPoint aParent) {
        this.parent = aParent;
    }

    public EtmPoint getParent() {
        return this.parent;
    }

    protected void setStartTime(long aStartTime) {
        this.startTime = aStartTime;
    }

    protected void setEndTime(long aEndTime) {
        this.endTime = aEndTime;
    }

    protected void setTicks(long aTicks) {
        this.ticks = aTicks;
    }

    public double getTransactionTime() {
        return (double)((this.endTime - this.startTime) * 1000L) / (double)this.ticks;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String toString() {
        return "MeasurementPoint{monitor=" + this.monitor + ", parent=" + this.parent + ", name='" + this.name + "'" + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", ticks=" + this.ticks + "}";
    }
}

