/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation;

import etm.core.aggregation.Aggregator;
import etm.core.aggregation.ExecutionAggregate;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.event.MonitorResetEvent;
import etm.core.monitor.event.PreMonitorResetEvent;
import etm.core.monitor.event.PreRootResetEvent;
import etm.core.monitor.event.RootCreateEvent;
import etm.core.monitor.event.RootResetEvent;
import etm.core.renderer.MeasurementRenderer;
import etm.core.util.collection.CollectionFactory;
import java.util.LinkedList;
import java.util.Map;

public class RootAggregator
implements Aggregator {
    protected Map aggregates = CollectionFactory.getInstance().newConcurrentHashMapInstance();
    protected EtmMonitorContext ctx;
    static /* synthetic */ Class class$etm$core$aggregation$RootAggregator;

    public void reset() {
        this.ctx.fireEvent(new PreMonitorResetEvent(this.aggregates, this));
        this.aggregates.clear();
        this.ctx.fireEvent(new MonitorResetEvent(this));
    }

    public void reset(String symbolicName) {
        ExecutionAggregate aggregate = (ExecutionAggregate)this.aggregates.get(symbolicName);
        if (aggregate != null) {
            this.ctx.fireEvent(new PreRootResetEvent(aggregate, this));
            aggregate.reset();
            this.ctx.fireEvent(new RootResetEvent(symbolicName, this));
        }
    }

    public void render(MeasurementRenderer renderer) {
        renderer.render(this.aggregates);
    }

    public void flush() {
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$core$aggregation$RootAggregator == null ? (class$etm$core$aggregation$RootAggregator = RootAggregator.class$("etm.core.aggregation.RootAggregator")) : class$etm$core$aggregation$RootAggregator, "An cummulating aggregator for flat and nested representation.", false);
    }

    public void start() {
    }

    public void stop() {
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
    }

    public void add(EtmPoint point) {
        EtmPoint rootNode;
        if (point.getParent() == null) {
            ExecutionAggregate aggregate = this.getAggregate(point.getName());
            aggregate.addTransaction(point);
            return;
        }
        LinkedList<EtmPoint> path = new LinkedList<EtmPoint>();
        path.add(point);
        for (rootNode = point.getParent(); rootNode != null; rootNode = rootNode.getParent()) {
            path.addFirst(rootNode);
        }
        rootNode = (EtmPoint)path.removeFirst();
        ExecutionAggregate aggregate = this.getAggregate(rootNode.getName());
        aggregate.appendPath(path);
    }

    protected ExecutionAggregate getAggregate(String aName) {
        ExecutionAggregate aggregate = (ExecutionAggregate)this.aggregates.get(aName);
        if (aggregate == null) {
            aggregate = new ExecutionAggregate(aName);
            this.aggregates.put(aName, aggregate);
            this.ctx.fireEvent(new RootCreateEvent(aggregate, this));
        }
        return aggregate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

