/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import de.mediathekview.mlib.tool.MVHttpClient;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;

public class FileSize {
    private FileSize() {
    }

    public static String laengeString(String url) {
        String groesseStr = "";
        long l = FileSize.getFileSizeFromUrl(url);
        if (l > 1000000L) {
            groesseStr = String.valueOf(l / 1000000L);
        } else if (l > 0L) {
            groesseStr = "1";
        }
        return groesseStr;
    }

    private static long getFileSizeFromUrl(String url) {
        if (!url.toLowerCase().startsWith("http")) {
            return -1L;
        }
        Request request = new Request.Builder().url(url).head().build();
        long respLength = -1L;
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                respLength = Long.parseLong(response.header("Content-Length", "-1"));
            }
        }
        catch (IOException | NumberFormatException ignored) {
            respLength = -1L;
        }
        if (respLength < 1000000L) {
            respLength = -1L;
        }
        return respLength;
    }
}

