/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.filmlisten;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLaden;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLadenEvent;
import de.mediathekview.mlib.tool.InputStreamProgressMonitor;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MVHttpClient;
import de.mediathekview.mlib.tool.ProgressMonitorInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import javax.swing.event.EventListenerList;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.time.FastDateFormat;
import org.tukaani.xz.XZInputStream;

public class FilmlisteLesen {
    private static final int PROGRESS_MAX = 100;
    private static WorkMode workMode = WorkMode.NORMAL;
    private final EventListenerList listeners = new EventListenerList();
    private int max = 0;
    private int progress = 0;
    private long milliseconds = 0L;

    public static void setWorkMode(WorkMode mode) {
        workMode = mode;
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private InputStream selectDecompressor(String source, InputStream in) throws Exception {
        if (source.endsWith(".xz")) {
            in = new XZInputStream(in);
        } else if (source.endsWith(".zip")) {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            zipInputStream.getNextEntry();
            in = zipInputStream;
        }
        return in;
    }

    private void readData(JsonParser jp, ListeFilme listeFilme) throws IOException {
        JsonToken jsonToken;
        String sender = "";
        String thema = "";
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected data to start with an Object");
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            for (int k = 0; k < 5; ++k) {
                listeFilme.metaDaten[k] = jp.nextTextValue();
            }
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            jp.nextToken();
            break;
        }
        while (!Config.getStop() && (jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            DatenFilm datenFilm = new DatenFilm();
            for (int i = 0; i < DatenFilm.JSON_NAMES.length; ++i) {
                if (workMode == WorkMode.FASTAUTO && (DatenFilm.JSON_NAMES[i] == 12 || DatenFilm.JSON_NAMES[i] == 15 || DatenFilm.JSON_NAMES[i] == 13)) {
                    jp.nextToken();
                    continue;
                }
                if (DatenFilm.JSON_NAMES[i] == 25) {
                    String value = jp.nextTextValue();
                    datenFilm.setNew(Boolean.parseBoolean(value));
                } else {
                    datenFilm.arr[DatenFilm.JSON_NAMES[i]] = jp.nextTextValue();
                }
                if (datenFilm.arr[DatenFilm.JSON_NAMES[i]] != null) continue;
                datenFilm.arr[DatenFilm.JSON_NAMES[i]] = "";
            }
            if (datenFilm.arr[1].isEmpty()) {
                datenFilm.arr[1] = sender;
            } else {
                sender = datenFilm.arr[1];
            }
            if (datenFilm.arr[2].isEmpty()) {
                datenFilm.arr[2] = thema;
            } else {
                thema = datenFilm.arr[2];
            }
            listeFilme.importFilmliste(datenFilm);
            if (this.milliseconds <= 0L || this.checkDate(datenFilm)) continue;
            listeFilme.remove(datenFilm);
        }
    }

    private void processFromFile(String source, ListeFilme listeFilme) {
        this.notifyProgress(source, 100);
        try (InputStream in = this.selectDecompressor(source, new FileInputStream(source));
             JsonParser jp = new JsonFactory().createParser(in);){
            this.readData(jp, listeFilme);
        }
        catch (FileNotFoundException ex) {
            Log.errorLog(894512369, "FilmListe existiert nicht: " + source);
            listeFilme.clear();
        }
        catch (Exception ex) {
            Log.errorLog(945123641, ex, "FilmListe: " + source);
            listeFilme.clear();
        }
    }

    private void checkDays(long days) {
        this.milliseconds = days > 0L ? System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS) : 0L;
    }

    public void readFilmListe(String source, ListeFilme listeFilme, int days) {
        try {
            Log.sysLog("Liste Filme lesen von: " + source);
            listeFilme.clear();
            this.notifyStart(source, 100);
            this.checkDays(days);
            if (!source.startsWith("http")) {
                this.processFromFile(source, listeFilme);
            } else {
                this.processFromWeb(new URL(source), listeFilme);
            }
            if (Config.getStop()) {
                Log.sysLog("--> Abbruch");
                listeFilme.clear();
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        this.notifyFertig(source, listeFilme);
    }

    private void processFromWeb(final URL source, ListeFilme listeFilme) {
        block31: {
            Request.Builder builder = new Request.Builder().url(source);
            builder.addHeader("User-Agent", Config.getUserAgent());
            InputStreamProgressMonitor monitor = new InputStreamProgressMonitor(){
                private int oldProgress = 0;

                @Override
                public void progress(long bytesRead, long size) {
                    int iProgress = (int)(bytesRead * 100L / size);
                    if (iProgress != this.oldProgress) {
                        this.oldProgress = iProgress;
                        FilmlisteLesen.this.notifyProgress(source.toString(), iProgress);
                    }
                }
            };
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(builder.build()).execute();
                 ResponseBody body = response.body();){
                if (!response.isSuccessful()) break block31;
                try (ProgressMonitorInputStream input = new ProgressMonitorInputStream(body.byteStream(), body.contentLength(), monitor);
                     InputStream is = this.selectDecompressor(source.toString(), input);
                     JsonParser jp = new JsonFactory().createParser(is);){
                    this.readData(jp, listeFilme);
                }
            }
            catch (Exception ex) {
                Log.errorLog(945123641, ex, "FilmListe: " + source);
                listeFilme.clear();
            }
        }
    }

    private boolean checkDate(DatenFilm film) {
        try {
            if (film.datumFilm.getTime() != 0L && film.datumFilm.getTime() < this.milliseconds) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.errorLog(495623014, ex);
        }
        return true;
    }

    private void notifyStart(String url, int mmax) {
        this.max = mmax;
        this.progress = 0;
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.start(new ListenerFilmeLadenEvent(url, "", this.max, 0, 0, false));
        }
    }

    private void notifyProgress(String url, int iProgress) {
        this.progress = iProgress;
        if (this.progress > this.max) {
            this.progress = this.max;
        }
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.progress(new ListenerFilmeLadenEvent(url, "Download", this.max, this.progress, 0, false));
        }
    }

    private void notifyFertig(String url, ListeFilme liste) {
        Log.sysLog("Liste Filme gelesen am: " + FastDateFormat.getInstance((String)"dd.MM.yyyy, HH:mm").format(new Date()));
        Log.sysLog("  erstellt am: " + liste.genDate());
        Log.sysLog("  Anzahl Filme: " + liste.size());
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(new ListenerFilmeLadenEvent(url, "", this.max, this.progress, 0, false));
        }
    }

    public static enum WorkMode {
        NORMAL,
        FASTAUTO;

    }
}

