/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import com.jidesoft.utils.SystemInfo;
import de.mediathekview.mlib.tool.Functions;
import de.mediathekview.mlib.tool.ReplaceList;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class FilenameUtils {
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS = "[:\\\\/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH = "[:/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS = "[:\\\\/*|<>]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH = "[:\\\\*|<>]";

    public static String checkDateiname(String name, boolean isPath) {
        String ret = name;
        boolean isWindowsPath = false;
        String splitChar = SystemInfo.isWindows() ? "\\\\" : "/";
        if (SystemInfo.isWindows()) {
            ret = FilenameUtils.removeWindowsTrailingDots(ret);
            if (isPath && ret.length() > 1 && ret.charAt(1) == ':') {
                isWindowsPath = true;
                ret = ret.replaceFirst(":", "");
            }
        } else {
            ret = FilenameUtils.removeStartingDots(ret);
        }
        if (isPath && ret.contains(File.separator)) {
            String[] sa;
            String str = "";
            for (String s : sa = ret.split(splitChar)) {
                if (s.isEmpty()) continue;
                str = str + File.separator + FilenameUtils.convertToNativeEncoding(s, false);
            }
            if (!ret.startsWith(File.separator)) {
                str = str.replaceFirst(splitChar, "");
            }
            if (ret.endsWith(File.separator)) {
                str = str + File.separator;
            }
            ret = str;
        } else {
            ret = FilenameUtils.convertToNativeEncoding(ret, false);
        }
        if (isWindowsPath) {
            if (ret.length() == 1) {
                ret = ret + ":";
            } else if (ret.length() > 1) {
                ret = ret.charAt(0) + ":" + ret.substring(1);
            }
        }
        return ret;
    }

    private static String removeWindowsTrailingDots(String fileName) {
        while (!fileName.isEmpty() && (fileName.endsWith(".") || fileName.endsWith(" "))) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName;
    }

    private static String removeStartingDots(String fileName) {
        while (!fileName.isEmpty() && fileName.startsWith(".")) {
            fileName = fileName.substring(1, fileName.length());
        }
        return fileName;
    }

    private static String convertToNativeEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = Charset.defaultCharset().newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String convertToASCIIEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = ret.replace("\u00e4", "ae");
        ret = ret.replace("\u00f6", "oe");
        ret = ret.replace("\u00fc", "ue");
        ret = ret.replace("\u00c4", "Ae");
        ret = ret.replace("\u00d6", "Oe");
        ret = ret.replace("\u00dc", "Ue");
        ret = ret.replace("\u00df", "ss");
        ret = FilenameUtils.cleanUnicode(ret);
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = Charset.forName("US-ASCII").newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String cleanUnicode(String ret) {
        String r = "";
        for (int i = 0; i < ret.length(); ++i) {
            char c = ret.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) {
                r = r + c;
                continue;
            }
            if (c == '\u00df') {
                r = r + "\u00df";
                continue;
            }
            if (c == '\u00c2' || c == '\u00c0' || c == '\u00c5' || c == '\u00c1') {
                r = r + "A";
                continue;
            }
            if (c == '\u00e5' || c == '\u00e1' || c == '\u00e0' || c == '\u00e2') {
                r = r + "a";
                continue;
            }
            if (c == '\u010c') {
                r = r + "C";
                continue;
            }
            if (c == '\u0107' || c == '\u010d' || c == '\u00e7') {
                r = r + "c";
                continue;
            }
            if (c == '\u0110') {
                r = r + "D";
                continue;
            }
            if (c == '\u00c9' || c == '\u00c8') {
                r = r + "E";
                continue;
            }
            if (c == '\u00e9' || c == '\u00e8' || c == '\u00ea' || c == '\u011b' || c == '\u00eb') {
                r = r + "e";
                continue;
            }
            if (c == '\u00ed') {
                r = r + "i";
                continue;
            }
            if (c == '\u00f1') {
                r = r + "n";
                continue;
            }
            if (c == '\u00f3' || c == '\u00f4' || c == '\u00f8') {
                r = r + "o";
                continue;
            }
            if (c == '\u0160') {
                r = r + "S";
                continue;
            }
            if (c == '\u015b' || c == '\u0161' || c == '\u015f') {
                r = r + "s";
                continue;
            }
            if (c == '\u0142' || c == '\u0141') {
                r = r + "t";
                continue;
            }
            if (c == '\u00fb' || c == '\u00f9') {
                r = r + "u";
                continue;
            }
            if (c == '\u00fd') {
                r = r + "y";
                continue;
            }
            if (c == '\u017d' || c == '\u0179') {
                r = r + "Z";
                continue;
            }
            if (c == '\u017e' || c == '\u017a') {
                r = r + "z";
                continue;
            }
            if (c == '\u00e6') {
                r = r + "ae";
                continue;
            }
            if (c == '\u2013') {
                r = r + "-";
                continue;
            }
            if (c == '\u201e') {
                r = r + "\"";
                continue;
            }
            if (c == '\u201d' || c == '\u201c' || c == '\u00ab' || c == '\u00bb') {
                r = r + "\"";
                continue;
            }
            if (c == '?') {
                r = r + "?";
                continue;
            }
            if (c == '\u00b0' || c == '\u2122') continue;
            if (c == '\u2026') {
                r = r + "...";
                continue;
            }
            if (c == '\u20ac') {
                r = r + "\u20ac";
                continue;
            }
            if (c == '\u00b4' || c == '\u2019' || c == '\u2018' || c == '\u00bf') {
                r = r + "'";
                continue;
            }
            if (c == '?') {
                r = r + "?";
                continue;
            }
            if (c == '\u0096') {
                r = r + "-";
                continue;
            }
            if (c == '\u0085' || c == '\u0080' || c == '\u0084' || c == '\u0092' || c == '\u0093') continue;
            if (c == '\u0091') {
                r = r + "-";
                continue;
            }
            if (c == '\n') continue;
            r = r + "_";
        }
        return r;
    }

    public static String removeIllegalCharacters(String input, boolean isPath) {
        String ret = input;
        switch (Functions.getOs()) {
            case MAC: 
            case LINUX: {
                ret = FilenameUtils.removeStartingDots(ret);
                ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH : REGEXP_ILLEGAL_CHARACTERS_OTHERS, "_");
                break;
            }
            case WIN64: 
            case WIN32: {
                ret = FilenameUtils.removeWindowsTrailingDots(ret);
                ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH : REGEXP_ILLEGAL_CHARACTERS_WINDOWS, "_");
                break;
            }
            default: {
                ret = FilenameUtils.removeStartingDots(ret);
                ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH : REGEXP_ILLEGAL_CHARACTERS_WINDOWS, "_");
            }
        }
        return ret;
    }

    public static String replaceLeerDateiname(String name, boolean isPath, boolean userReplace, boolean onlyAscii) {
        String ret = name;
        boolean isWindowsPath = false;
        if (SystemInfo.isWindows() && isPath && ret.length() > 1 && ret.charAt(1) == ':') {
            isWindowsPath = true;
            ret = ret.replaceFirst(":", "");
        }
        if (userReplace) {
            ret = ReplaceList.replace(ret, isPath);
        }
        ret = onlyAscii ? FilenameUtils.convertToASCIIEncoding(ret, isPath) : FilenameUtils.convertToNativeEncoding(ret, isPath);
        if (isWindowsPath) {
            if (ret.length() == 1) {
                ret = ret + ":";
            } else if (ret.length() > 1) {
                ret = ret.charAt(0) + ":" + ret.substring(1);
            }
        }
        return ret;
    }
}

