/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.filmlisten;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.jidesoft.utils.SystemInfo;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class WriteFilmlistJson {
    private void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    protected JsonGenerator getJsonGenerator(OutputStream os) throws IOException {
        JsonFactory jsonF = new JsonFactory();
        JsonGenerator jg = jsonF.createGenerator(os, JsonEncoding.UTF8);
        return jg;
    }

    public void filmlisteSchreibenJsonCompressed(String datei, ListeFilme listeFilme) {
        String tempFile = datei + "_temp";
        this.filmlisteSchreibenJson(tempFile, listeFilme);
        try {
            Log.sysLog("Komprimiere Datei: " + datei);
            if (datei.endsWith(".xz")) {
                Path xz = this.testNativeXz();
                if (xz != null) {
                    Process p = new ProcessBuilder(xz.toString(), "-9", tempFile).start();
                    int exitCode = p.waitFor();
                    if (exitCode == 0) {
                        Files.move(Paths.get(tempFile + ".xz", new String[0]), Paths.get(datei, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    this.compressFile(tempFile, datei);
                }
            }
            Files.deleteIfExists(Paths.get(tempFile, new String[0]));
        }
        catch (IOException | InterruptedException ex) {
            Log.sysLog("Komprimieren fehlgeschlagen");
        }
    }

    public void filmlisteSchreibenJson(String datei, ListeFilme listeFilme) {
        try {
            Path f;
            Path parentDirectory;
            Log.sysLog("Filme schreiben (" + listeFilme.size() + " Filme) :");
            Log.sysLog("   --> Start Schreiben nach: " + datei);
            String sender = "";
            String thema = "";
            if (SystemInfo.isMacOSX() && !Files.exists(parentDirectory = (f = Paths.get(datei, new String[0])).getParent(), new LinkOption[0])) {
                Files.createDirectory(parentDirectory, new FileAttribute[0]);
            }
            try (FileOutputStream fos = new FileOutputStream(datei);
                 JsonGenerator jg = this.getJsonGenerator(fos);){
                int i;
                jg.writeStartObject();
                jg.writeArrayFieldStart("Filmliste");
                for (i = 0; i < 5; ++i) {
                    jg.writeString(listeFilme.metaDaten[i]);
                }
                jg.writeEndArray();
                jg.writeArrayFieldStart("Filmliste");
                for (i = 0; i < DatenFilm.JSON_NAMES.length; ++i) {
                    jg.writeString(DatenFilm.COLUMN_NAMES[DatenFilm.JSON_NAMES[i]]);
                }
                jg.writeEndArray();
                for (DatenFilm datenFilm : listeFilme) {
                    datenFilm.arr[25] = Boolean.toString(datenFilm.isNew());
                    jg.writeArrayFieldStart("X");
                    for (int i2 = 0; i2 < DatenFilm.JSON_NAMES.length; ++i2) {
                        int m = DatenFilm.JSON_NAMES[i2];
                        if (m == 1) {
                            if (datenFilm.arr[m].equals(sender)) {
                                jg.writeString("");
                                continue;
                            }
                            sender = datenFilm.arr[m];
                            jg.writeString(datenFilm.arr[m]);
                            continue;
                        }
                        if (m == 2) {
                            if (datenFilm.arr[m].equals(thema)) {
                                jg.writeString("");
                                continue;
                            }
                            thema = datenFilm.arr[m];
                            jg.writeString(datenFilm.arr[m]);
                            continue;
                        }
                        jg.writeString(datenFilm.arr[m]);
                    }
                    jg.writeEndArray();
                }
                jg.writeEndObject();
                Log.sysLog("   --> geschrieben!");
            }
        }
        catch (Exception ex) {
            Log.errorLog(846930145, ex, "nach: " + datei);
        }
    }

    private Path testNativeXz() {
        String path;
        String[] paths = new String[]{"/usr/bin/xz", "/opt/local/bin/xz", "/usr/local/bin/xz"};
        Path xz = null;
        String[] stringArray = paths;
        int n = stringArray.length;
        for (int i = 0; i < n && !Files.isExecutable(xz = Paths.get(path = stringArray[i], new String[0])); ++i) {
        }
        return xz;
    }

    private void compressFile(String inputName, String outputName) throws IOException {
        try (FileInputStream input = new FileInputStream(inputName);
             FileOutputStream fos = new FileOutputStream(outputName);
             XZOutputStream output = new XZOutputStream((OutputStream)fos, (FilterOptions)new LZMA2Options());
             ReadableByteChannel inputChannel = Channels.newChannel(input);
             WritableByteChannel outputChannel = Channels.newChannel((OutputStream)output);){
            this.fastChannelCopy(inputChannel, outputChannel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

