/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import com.jidesoft.utils.SystemInfo;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Functions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;

public class Log {
    private static final String FEHLER = "Fehler(MSearch): ";
    public static final String LILNE = "################################################################################";
    private static final LinkedList<Error> fehlerListe = new LinkedList();
    private static boolean progress = false;
    public static final Date startZeit = new Date(System.currentTimeMillis());
    private static File logFile = null;
    private static final ArrayList<String> logList = new ArrayList();
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final long TO_MEGABYTE = 1000000L;

    public static synchronized void setLogfile(String logFileString) {
        logFile = new File(logFileString);
        File dir = new File(logFile.getParent());
        if (!dir.exists() && !dir.mkdirs()) {
            logFile = null;
            Log.errorLog(632012165, "Kann den Pfad nicht anlegen: " + dir.toString());
        }
    }

    public static void versionMsg(String progName) {
        String[] java;
        if (!SystemInfo.isMacOSX()) {
            Log.sysLog("");
            Log.sysLog("");
            Log.sysLog("");
            Log.sysLog("");
            Log.sysLog("");
            Log.sysLog("___  ___         _ _       _   _          _    _   _ _               ");
            Log.sysLog("|  \\/  |        | (_)     | | | |        | |  | | | (_)              ");
            Log.sysLog("| .  . | ___  __| |_  __ _| |_| |__   ___| | _| | | |_  _____      __");
            Log.sysLog("| |\\/| |/ _ \\/ _` | |/ _` | __| '_ \\ / _ \\ |/ / | | | |/ _ \\ \\ /\\ / /");
            Log.sysLog("| |  | |  __/ (_| | | (_| | |_| | | |  __/   <\\ \\_/ / |  __/\\ V  V / ");
            Log.sysLog("\\_|  |_/\\___|\\__,_|_|\\__,_|\\__|_| |_|\\___|_|\\_\\\\___/|_|\\___| \\_/\\_/  ");
            Log.sysLog("");
            Log.sysLog("");
        }
        Log.sysLog(LILNE);
        Log.sysLog("Programmstart: " + dateFormatter.format(startZeit));
        Log.sysLog(LILNE);
        Log.sysLog("");
        long totalMem = Runtime.getRuntime().totalMemory();
        Log.sysLog("totalMemory: " + totalMem / 1000000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        Log.sysLog("maxMemory: " + maxMem / 1000000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        Log.sysLog("freeMemory: " + freeMem / 1000000L + " MB");
        Log.sysLog("");
        Log.sysLog(LILNE);
        Log.sysLog("");
        Log.sysLog(progName + Functions.getProgVersionString());
        String compile = Functions.getCompileDate();
        if (!compile.isEmpty()) {
            Log.sysLog("Compiled: " + compile);
        }
        Log.sysLog("");
        Log.sysLog(LILNE);
        Log.sysLog("");
        Log.sysLog("Java");
        for (String ja : java = Functions.getJavaVersion()) {
            Log.sysLog(ja);
        }
        Log.sysLog("");
    }

    public static void endMsg() {
        int minuten;
        Log.sysLog("");
        Log.sysLog("");
        Log.sysLog("");
        Log.sysLog("");
        Log.printErrorMsg().forEach(Log::sysLog);
        Date stopZeit = new Date(System.currentTimeMillis());
        try {
            minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        Log.sysLog("");
        Log.sysLog("");
        Log.sysLog(LILNE);
        Log.sysLog("   --> Beginn: " + dateFormatter.format(startZeit));
        Log.sysLog("   --> Fertig: " + dateFormatter.format(stopZeit));
        Log.sysLog("   --> Dauer[Min]: " + String.valueOf(minuten == 0 ? "<1" : Integer.valueOf(minuten)));
        Log.sysLog(LILNE);
        Log.sysLog("");
        Log.sysLog("   und Tschuess");
        Log.sysLog("");
        Log.sysLog("");
        Log.sysLog(LILNE);
    }

    public static synchronized ArrayList<String> printErrorMsg() {
        int max = 0;
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("");
        retList.add(LILNE);
        if (fehlerListe.isEmpty()) {
            retList.add(" Keine Fehler :)");
        } else {
            for (Error e : fehlerListe) {
                if (e.cl.length() <= max) continue;
                max = e.cl.length();
            }
            ++max;
            for (Error e : fehlerListe) {
                while (e.cl.length() < max) {
                    e.cl = e.cl + " ";
                }
            }
            for (int i = 1; i < fehlerListe.size(); ++i) {
                int i_2;
                int i_1;
                for (int k = i; k > 0 && (i_1 = Log.fehlerListe.get((int)(k - 1)).nr) < (i_2 = Log.fehlerListe.get((int)k).nr); --k) {
                    fehlerListe.add(k - 1, fehlerListe.remove(k));
                }
            }
            for (Error e : fehlerListe) {
                String strEx = e.ex ? "Ex! " : "    ";
                retList.add(strEx + e.cl + " Fehlernummer: " + e.nr + " Anzahl: " + e.count);
            }
        }
        retList.add(LILNE);
        return retList;
    }

    public static synchronized void errorLog(int fehlerNummer, Exception ex) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[0]);
    }

    public static synchronized void errorLog(int fehlerNummer, Exception ex, String text) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[]{text});
    }

    public static synchronized void errorLog(int fehlerNummer, Exception ex, String[] text) {
        Log.fehlermeldung_(fehlerNummer, ex, text);
    }

    public static synchronized void errorLog(int fehlerNummer, String text) {
        Log.fehlermeldung_(fehlerNummer, null, new String[]{text});
    }

    public static synchronized void errorLog(int fehlerNummer, String[] text) {
        Log.fehlermeldung_(fehlerNummer, null, text);
    }

    public static synchronized void sysLog(String text) {
        Log.systemmeldung_(new String[]{text});
    }

    public static synchronized void progress(String texte) {
        progress = true;
        if (!texte.isEmpty()) {
            System.out.print(texte + "\r");
        }
    }

    private static void resetProgress() {
        if (progress) {
            System.out.print("                                                                                                             \r");
            progress = false;
        }
    }

    private static void addFehlerNummer(int nr, String classs, boolean exception) {
        for (Error e : fehlerListe) {
            if (e.nr != nr) continue;
            ++e.count;
            return;
        }
        fehlerListe.add(new Error(nr, classs, exception));
    }

    private static void fehlermeldung_(int fehlerNummer, Exception ex, String[] texte) {
        Object kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (((String)kl).contains(".") && !Character.isUpperCase(((String)kl).charAt(0))) {
                kl = ((String)kl).substring(((String)kl).indexOf(46) + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        Log.addFehlerNummer(fehlerNummer, (String)kl, ex != null);
        if (ex != null || Config.debug) {
            Log.resetProgress();
            String x = ex != null ? "!" : "=";
            String z = "*";
            logList.add(x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x);
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                if (ex != null) {
                    ex.printStackTrace(pw);
                }
                pw.flush();
                sw.flush();
                logList.add(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logList.add(z + " Fehlernr: " + fehlerNummer);
            if (ex != null) {
                logList.add(z + " Exception: " + ex.getMessage());
            }
            logList.add(z + " Fehler(MSearch): " + (String)kl);
            for (String aTexte : texte) {
                logList.add(z + "           " + aTexte);
            }
            logList.add("");
            Log.printLog();
        }
    }

    private static void systemmeldung_(String[] texte) {
        Log.resetProgress();
        String z = ". ";
        if (texte.length <= 1) {
            logList.add(".  " + texte[0]);
        } else {
            String zeile = "---------------------------------------";
            logList.add(". " + zeile);
            for (String aTexte : texte) {
                String txt = "| " + aTexte;
                logList.add(". " + txt);
            }
            logList.add(". " + zeile);
        }
        Log.printLog();
    }

    private static void printLog() {
        logList.forEach(System.out::println);
        if (logFile != null) {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, true), StandardCharsets.UTF_8);){
                for (String s : logList) {
                    out.write(s);
                    out.write("\n");
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        logList.clear();
    }

    private static class Error {
        String cl = "";
        int nr = 0;
        int count = 0;
        boolean ex = false;

        public Error(int nr, String cl, boolean ex) {
            this.nr = nr;
            this.cl = cl;
            this.ex = ex;
            this.count = 1;
        }
    }
}

