/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import de.mediathekview.mlib.tool.Log;

public class Version {
    private int major;
    private int minor;
    private int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(String versionsstring) {
        String[] versions = versionsstring.split("\\.");
        if (versions.length == 3) {
            try {
                this.major = Integer.parseInt(versions[0]);
                this.minor = Integer.parseInt(versions[1]);
                this.patch = Integer.parseInt(versions[2]);
            }
            catch (NumberFormatException ex) {
                Log.errorLog(12344564, (Exception)ex, "Fehler beim Parsen der Version '" + versionsstring + "'.");
                this.major = 0;
                this.minor = 0;
                this.patch = 0;
            }
        }
    }

    public Version() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public int toNumber() {
        return this.major * 100 + this.minor * 10 + this.patch;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int compare(Version versionzwei) {
        if (this.toNumber() < versionzwei.toNumber()) {
            return 1;
        }
        if (this.toNumber() == versionzwei.toNumber()) {
            return 0;
        }
        return -1;
    }
}

