/*
 * Decompiled with CFR 0.152.
 */
package mSearch.tool.javafx;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;

public class FXErrorDialog {
    public static void showErrorDialog(String title, String header, String detailedErrorMessage, Exception ex) {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle(title);
            alert.setHeaderText(header);
            alert.setContentText(detailedErrorMessage);
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                ex.printStackTrace(pw);
                String exceptionText = sw.toString();
                Label label = new Label("Stacktrace:");
                TextArea textArea = new TextArea(exceptionText);
                textArea.setEditable(false);
                textArea.setWrapText(true);
                textArea.setMaxWidth(Double.MAX_VALUE);
                textArea.setMaxHeight(Double.MAX_VALUE);
                GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                GridPane expContent = new GridPane();
                expContent.setMaxWidth(Double.MAX_VALUE);
                expContent.add((Node)label, 0, 0);
                expContent.add((Node)textArea, 0, 1);
                alert.getDialogPane().setExpandableContent((Node)expContent);
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.showAndWait();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

