/*
 * Decompiled with CFR 0.152.
 */
package mSearch.tool;

import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.CodeSource;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import mSearch.Const;
import mSearch.tool.Log;
import mSearch.tool.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Functions {
    private static final String RBVERSION = "version";
    private static final Logger logger = LogManager.getLogger(Functions.class);
    private static final Pattern PATTERN = Pattern.compile("\\<.*?>");

    public static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        StringBuilder textBuilder = new StringBuilder(text);
        while (textBuilder.length() < max) {
            if (addVorne) {
                textBuilder.insert(0, ' ');
                continue;
            }
            textBuilder.append(' ');
        }
        text = textBuilder.toString();
        return text;
    }

    public static OperatingSystemType getOs() {
        OperatingSystemType os = OperatingSystemType.UNKNOWN;
        if (SystemInfo.isWindows()) {
            if (System.getenv("ProgramFiles(x86)") != null) {
                os = OperatingSystemType.WIN64;
            } else if (System.getenv("ProgramFiles") != null) {
                os = OperatingSystemType.WIN32;
            }
        } else if (SystemInfo.isLinux() || System.getProperty("os.name").toLowerCase().contains("freebsd")) {
            os = OperatingSystemType.LINUX;
        } else if (SystemInfo.isMacOSX()) {
            os = OperatingSystemType.MAC;
        }
        return os;
    }

    public static String getOsString() {
        return Functions.getOs().toString();
    }

    public static String getPathJar() {
        String pFilePath = "version.properties";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Const.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception cS) {}
        } else {
            logger.debug("getPathJar() propFile does exist");
        }
        String s = StringUtils.replace((String)propFile.getAbsolutePath(), (String)pFilePath, (String)"");
        if (!s.endsWith(File.separator)) {
            s = s + File.separator;
        }
        if (s.endsWith("/lib/")) {
            s = StringUtils.replace((String)s, (String)"/lib/", (String)"");
        }
        return s;
    }

    public static String getProgVersionString() {
        return " [Vers.: " + Functions.getProgVersion().toString() + ']';
    }

    public static String[] getJavaVersion() {
        String[] ret = new String[]{"Vendor: " + System.getProperty("java.vendor"), "VMname: " + System.getProperty("java.vm.name"), "Version: " + System.getProperty("java.version"), "Runtimeversion: " + System.getProperty("java.runtime.version")};
        return ret;
    }

    public static String getCompileDate() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(propToken)) {
                msg = rb.getString(propToken);
            }
        }
        catch (Exception e) {
            Log.errorLog(807293847, e);
        }
        return msg;
    }

    public static Version getProgVersion() {
        String TOKEN_VERSION = "VERSION";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(TOKEN_VERSION)) {
                return new Version(rb.getString(TOKEN_VERSION));
            }
        }
        catch (Exception e) {
            Log.errorLog(134679898, e);
        }
        return new Version("");
    }

    @Deprecated
    public static String getBuildNr() {
        String TOKEN_VERSION = "VERSION";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(TOKEN_VERSION)) {
                return new Version(rb.getString(TOKEN_VERSION)).toString();
            }
        }
        catch (Exception e) {
            Log.errorLog(134679898, e);
        }
        return new Version("").toString();
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") || dateiUrl.startsWith("www");
    }

    public static String removeHtml(String in) {
        return PATTERN.matcher(in).replaceAll("");
    }

    public static enum OperatingSystemType {
        UNKNOWN(""),
        WIN32("Windows"),
        WIN64("Windows"),
        LINUX("Linux"),
        MAC("Mac");

        private final String name;

        private OperatingSystemType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

