/*
 * Decompiled with CFR 0.152.
 */
package mSearch.tool;

import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.util.NoSuchElementException;
import javafx.animation.PauseTransition;
import javafx.util.Duration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;

public class ApplicationConfiguration {
    public static final String APPLICATION_USER_AGENT = "application.user_agent";
    public static final String APPLICATION_INSTALL_TAB_SWITCH_LISTENER = "application.ui.install_tab_listeners";
    public static final String APPLICATION_FORCE_UPDATE_SERVER_RELOAD_AKT = "application.force_update_server_reload.akt";
    public static final String APPLICATION_FORCE_UPDATE_SERVER_RELOAD_DIFF = "application.force_update_server_reload.diff";
    public static final String HTTP_PROXY_HOSTNAME = "http.proxy.hostname";
    public static final String HTTP_PROXY_PORT = "http.proxy.port";
    public static final String HTTP_PROXY_USERNAME = "http.proxy.user";
    public static final String HTTP_PROXY_PASSWORD = "http.proxy.password";
    public static final String FILTER_PANEL_SHOW_HD_ONLY = "filter.show.hd_only";
    public static final String FILTER_PANEL_SHOW_SUBTITLES_ONLY = "filter.show.subtitles_only";
    public static final String FILTER_PANEL_SHOW_NEW_ONLY = "filter.show.new_only";
    public static final String FILTER_PANEL_SHOW_UNSEEN_ONLY = "filter.show.unseen_only";
    public static final String FILTER_PANEL_SHOW_LIVESTREAMS_ONLY = "filter.show.livestreams_only";
    public static final String FILTER_PANEL_DONT_SHOW_ABOS = "filter.dont_show.abos";
    public static final String FILTER_PANEL_DONT_SHOW_TRAILERS = "filter.dont_show.trailers";
    public static final String FILTER_PANEL_DONT_SHOW_SIGN_LANGUAGE = "filter.dont_show.sign_language";
    public static final String FILTER_PANEL_DONT_SHOW_AUDIO_VERSIONS = "filter.dont_show.audio_versions";
    public static final String FILTER_PANEL_FILM_LENGTH_MIN = "filter.film_length.min";
    public static final String FILTER_PANEL_FILM_LENGTH_MAX = "filter.film_length.max";
    public static final String FILTER_PANEL_ZEITRAUM = "filter.zeitraum";
    public static final String GEO_REPORT = "geo.report";
    public static final String GEO_LOCATION = "geo.location";
    private static final ApplicationConfiguration ourInstance = new ApplicationConfiguration();
    private XMLConfiguration config;
    private FileHandler handler;

    private ApplicationConfiguration() {
        this.setupXmlConfiguration();
        this.createFileHandler();
        this.loadOrCreateConfiguration();
    }

    public static ApplicationConfiguration getInstance() {
        return ourInstance;
    }

    public static Configuration getConfiguration() {
        return ApplicationConfiguration.ourInstance.config;
    }

    private void setupXmlConfiguration() {
        this.config = new XMLConfiguration();
        this.config.setSynchronizer((Synchronizer)new ReadWriteSynchronizer());
        this.config.setRootElementName("settings");
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)new EvtListener());
        this.config.setThrowExceptionOnMissing(true);
    }

    private void createFileHandler() {
        this.handler = new FileHandler((FileBased)this.config);
        this.handler.setEncoding("UTF-8");
        this.handler.setPath(System.getProperty("user.home") + File.separatorChar + ".mediathek3" + File.separatorChar + "settings.xml");
    }

    private void loadOrCreateConfiguration() {
        try {
            this.handler.load();
            this.updateNewerDefaults();
        }
        catch (ConfigurationException cex) {
            this.createDefaultConfigSettings();
        }
    }

    public void writeConfiguration() {
        try {
            this.handler.save();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private void createDefaultConfigSettings() {
        try {
            this.config.setProperty(APPLICATION_USER_AGENT, (Object)"MediathekView");
            this.config.setProperty(GEO_REPORT, (Object)true);
            this.config.setProperty(GEO_LOCATION, (Object)"DE");
            this.handler.save();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void updateNewerDefaults() {
        try {
            boolean bl = this.config.getBoolean(GEO_REPORT);
        }
        catch (NoSuchElementException ignored) {
            this.config.setProperty(GEO_REPORT, (Object)true);
        }
        try {
            String ignored = this.config.getString(GEO_LOCATION);
        }
        catch (NoSuchElementException ignored) {
            this.config.setProperty(GEO_LOCATION, (Object)"DE");
        }
        try {
            boolean ignored = this.config.getBoolean(APPLICATION_INSTALL_TAB_SWITCH_LISTENER);
        }
        catch (NoSuchElementException ignored) {
            if (SystemInfo.isMacOSX()) {
                this.config.setProperty(APPLICATION_INSTALL_TAB_SWITCH_LISTENER, (Object)false);
            }
            this.config.setProperty(APPLICATION_INSTALL_TAB_SWITCH_LISTENER, (Object)true);
        }
    }

    private final class EvtListener
    implements EventListener<ConfigurationEvent> {
        private final PauseTransition pause = new PauseTransition(Duration.millis((double)5000.0));

        public EvtListener() {
            this.pause.setOnFinished(evtl -> {
                try {
                    ApplicationConfiguration.this.handler.save();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
            });
        }

        public void onEvent(ConfigurationEvent configurationEvent) {
            if (!configurationEvent.isBeforeUpdate()) {
                this.pause.playFromStart();
            }
        }
    }
}

