/*
 * Decompiled with CFR 0.152.
 */
package mSearch.filmlisten;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mSearch.filmlisten.DatenFilmlisteUrl;
import mSearch.filmlisten.ListeFilmlistenUrls;
import mSearch.tool.ApplicationConfiguration;
import mSearch.tool.Functions;
import mSearch.tool.Log;
import mSearch.tool.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.configuration2.Configuration;

public class FilmlistenSuchen {
    public ListeFilmlistenUrls listeFilmlistenUrls_akt = new ListeFilmlistenUrls();
    public ListeFilmlistenUrls listeFilmlistenUrls_diff = new ListeFilmlistenUrls();
    private static boolean firstSearchAkt = true;
    private static boolean firstSearchDiff = true;
    private static final int UPDATE_LISTE_MAX = 10;
    private final XMLInputFactory inFactory = XMLInputFactory.newInstance();

    private void forceUpdateServerReload(ListeFilmlistenUrls liste, String configStr) {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean forceReload = config.getBoolean(configStr, true);
        if (forceReload) {
            liste.clear();
            config.setProperty(configStr, (Object)false);
        }
    }

    public String suchenAkt(ArrayList<String> bereitsVersucht) {
        int nr;
        this.forceUpdateServerReload(this.listeFilmlistenUrls_akt, "application.force_update_server_reload.akt");
        if (this.listeFilmlistenUrls_akt.isEmpty()) {
            this.updateURLsFilmlisten(true);
        } else if (firstSearchAkt && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(true);
        }
        firstSearchAkt = false;
        String retUrl = this.listeFilmlistenUrls_akt.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    public String suchenDiff(ArrayList<String> bereitsVersucht) {
        int nr;
        this.forceUpdateServerReload(this.listeFilmlistenUrls_diff, "application.force_update_server_reload.diff");
        if (this.listeFilmlistenUrls_diff.isEmpty()) {
            this.updateURLsFilmlisten(false);
        } else if (firstSearchDiff && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(false);
        }
        firstSearchDiff = false;
        String retUrl = this.listeFilmlistenUrls_diff.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    private void insertDefaultActiveServers() {
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler1.mediathekview.de/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler2.mediathekview.de/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler3.mediathekview.de/Filmliste-akt.xz", "akt"));
        this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://verteiler4.mediathekview.de/Filmliste-akt.xz", "akt"));
    }

    private void insertDefaultDifferentialListServers() {
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler1.mediathekview.de/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler2.mediathekview.de/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler3.mediathekview.de/Filmliste-diff.xz", "diff"));
        this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://verteiler4.mediathekview.de/Filmliste-diff.xz", "diff"));
    }

    public void updateURLsFilmlisten(boolean updateFullList) {
        ListeFilmlistenUrls tmp = new ListeFilmlistenUrls();
        if (updateFullList) {
            this.getFilmlistServerUrls("http://res.mediathekview.de/akt.xml", tmp, "akt");
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_akt = tmp;
            } else if (this.listeFilmlistenUrls_akt.isEmpty()) {
                this.insertDefaultActiveServers();
            }
            this.listeFilmlistenUrls_akt.sort();
        } else {
            this.getFilmlistServerUrls("http://res.mediathekview.de/diff.xml", tmp, "diff");
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_diff = tmp;
            } else if (this.listeFilmlistenUrls_diff.isEmpty()) {
                this.insertDefaultDifferentialListServers();
            }
            this.listeFilmlistenUrls_diff.sort();
        }
        if (tmp.isEmpty()) {
            Log.errorLog(491203216, new String[]{"Es ist ein Fehler aufgetreten!", "Es konnten keine Updateserver zum aktualisieren der Filme", "gefunden werden."});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String dateiUrl, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        Path filePath = Paths.get(dateiUrl, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        XMLStreamReader parser = null;
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);
             InputStreamReader inReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            parser = this.inFactory.createXMLStreamReader(inReader);
            this.parseData(parser, listeFilmlistenUrls, art);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private void parseData(XMLStreamReader parser, ListeFilmlistenUrls listeFilmlistenUrls, String art) throws XMLStreamException {
        while (parser.hasNext()) {
            String parsername;
            int event = parser.next();
            if (event != 1 || !(parsername = parser.getLocalName()).equals("Server")) continue;
            this.parseServerEntry(parser, listeFilmlistenUrls, art);
        }
    }

    public FilmlistenSuchen() {
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWebLocation(URL dateiUrl, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        block55: {
            Request request = new Request.Builder().url(dateiUrl).get().build();
            try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful() && body != null) {
                    try (XMLStreamReader parser = null;
                         InputStream is = body.byteStream();
                         InputStreamReader inReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        parser = this.inFactory.createXMLStreamReader(inReader);
                        this.parseData(parser, listeFilmlistenUrls, art);
                        break block55;
                    }
                }
                throw new Exception();
            }
            catch (Exception ex) {
                Log.errorLog(821069874, ex, "Die URL-Filmlisten konnte nicht geladen werden: " + dateiUrl);
            }
        }
    }

    private void getFilmlistServerUrls(String dateiUrl, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        try {
            if (Functions.istUrl(dateiUrl)) {
                this.readWebLocation(new URL(dateiUrl), listeFilmlistenUrls, art);
            } else {
                this.readFile(dateiUrl, listeFilmlistenUrls, art);
            }
        }
        catch (MalformedURLException ex) {
            Log.sysLog("Fehlerhafte Update-Server-URL gelesen: " + dateiUrl);
        }
    }

    private void parseServerEntry(XMLStreamReader parser, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        String serverUrl = "";
        String prio = "";
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1) {
                    switch (parser.getLocalName()) {
                        case "URL": {
                            serverUrl = parser.getElementText();
                            break;
                        }
                        case "Prio": {
                            prio = parser.getElementText();
                        }
                    }
                }
                if (event != 2 || !parser.getLocalName().equals("Server")) continue;
                if (!serverUrl.isEmpty()) {
                    if (prio.isEmpty()) {
                        prio = "1";
                    }
                    listeFilmlistenUrls.addWithCheck(new DatenFilmlisteUrl(serverUrl, prio, art));
                }
                break;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

