/*
 * Decompiled with CFR 0.152.
 */
package mSearch.daten;

import com.jidesoft.utils.SystemInfo;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PooledDatabaseConnection
implements Closeable {
    private static PooledDatabaseConnection INSTANCE;
    private final DataSource dataSource = this.setupDataSource();
    private ObjectPool<PoolableConnection> connectionPool;

    private PooledDatabaseConnection() {
    }

    public static PooledDatabaseConnection getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PooledDatabaseConnection();
        }
        return INSTANCE;
    }

    @Override
    public void close() {
        this.connectionPool.close();
    }

    public Connection getConnection() {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return con;
    }

    private DataSource setupDataSource() {
        String CACHE_PATH = SystemInfo.isMacOSX() ? System.getProperty("user.home") + "/Library/Caches/MediathekView/" : System.getProperty("user.home") + File.separatorChar + ".mediathek3" + File.separatorChar;
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Properties props = new Properties();
        props.put("maxTotal", String.valueOf(Runtime.getRuntime().availableProcessors()));
        props.put("poolPreparedStatements", "true");
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:hsqldb:file:" + CACHE_PATH + "cache.db;close_result=true;shutdown=true", props);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        this.connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool(this.connectionPool);
        return new PoolingDataSource(this.connectionPool);
    }
}

