/*
 * Decompiled with CFR 0.152.
 */
package mSearch.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import mSearch.Const;
import mSearch.daten.DatenFilm;
import mSearch.tool.GermanStringSorter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListeFilme
extends ArrayList<DatenFilm> {
    public static final String THEMA_LIVE = "Livestream";
    public static final String FILMLISTE = "Filmliste";
    public static final int FILMLISTE_DATUM_GMT_NR = 1;
    public static final int FILMLISTE_ID_NR = 4;
    public static final int MAX_ELEM = 5;
    private static final String DATUM_ZEIT_FORMAT = "dd.MM.yyyy, HH:mm";
    private static final SimpleDateFormat sdf_ = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    private static final Logger logger = LogManager.getLogger(ListeFilme.class);
    private static final String THEME_SEARCH_TEXT = "Themen in Filmliste suchen";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    public int nr = 1;
    public String[] metaDaten = new String[]{"", "", "", "", ""};
    public String[] sender = new String[]{""};
    public ObservableList<String> senderList = FXCollections.observableArrayList();
    public String[][] themenPerSender = new String[][]{{""}};
    public boolean neueFilme = false;

    public ListeFilme() {
        sdf_.setTimeZone(new SimpleTimeZone(2, "UTC"));
    }

    public synchronized void importFilmliste(DatenFilm film) {
        this.addInit(film);
    }

    private void addHash(DatenFilm f, HashSet<String> hash, boolean index) {
        if (f.getSender().equals("KiKA")) {
            hash.add(f.arr[2] + f.getTitle());
        } else if (index) {
            hash.add(f.getIndex());
        } else {
            hash.add(f.getUrl());
        }
    }

    public synchronized void updateListe(ListeFilme listeEinsortieren, boolean index, boolean ersetzen) {
        HashSet hash = new HashSet(listeEinsortieren.size() + 1, 1.0f);
        if (ersetzen) {
            listeEinsortieren.forEach((? super E f) -> this.addHash((DatenFilm)f, hash, index));
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DatenFilm f2 = (DatenFilm)it.next();
                if (f2.getSender().equals("KiKA")) {
                    if (!hash.contains(f2.arr[2] + f2.getTitle())) continue;
                    it.remove();
                    continue;
                }
                if (index) {
                    if (!hash.contains(f2.getIndex())) continue;
                    it.remove();
                    continue;
                }
                if (!hash.contains(f2.getUrl())) continue;
                it.remove();
            }
            listeEinsortieren.forEach(this::addInit);
        } else {
            this.forEach((? super E f) -> this.addHash((DatenFilm)f, hash, index));
            for (DatenFilm f3 : listeEinsortieren) {
                if (f3.getSender().equals("KiKA")) {
                    if (hash.contains(f3.arr[2] + f3.getTitle())) continue;
                    this.addInit(f3);
                    continue;
                }
                if (index) {
                    if (hash.contains(f3.getIndex())) continue;
                    this.addInit(f3);
                    continue;
                }
                if (hash.contains(f3.getUrl())) continue;
                this.addInit(f3);
            }
        }
        hash.clear();
    }

    private boolean addInit(DatenFilm film) {
        film.init();
        return this.add(film);
    }

    @Override
    public boolean add(DatenFilm aFilm) {
        return super.add(aFilm);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        this.neueFilme = false;
        super.clear();
    }

    public synchronized void setMeta(ListeFilme listeFilme) {
        System.arraycopy(listeFilme.metaDaten, 0, this.metaDaten, 0, 5);
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        Optional<DatenFilm> opt = this.parallelStream().filter(f -> f.arr[13].equalsIgnoreCase(url)).findAny();
        return opt.orElse(null);
    }

    public synchronized DatenFilm getFilmByUrl_klein_hoch_hd(String url) {
        DatenFilm ret = null;
        for (DatenFilm f : this) {
            if (f.arr[13].equals(url)) {
                ret = f;
                break;
            }
            if (f.getUrlFuerAufloesung("hd").equals(url)) {
                ret = f;
                break;
            }
            if (!f.getUrlFuerAufloesung("klein").equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized String genDate() {
        String ret;
        String date = this.metaDaten[1];
        try {
            Date filmDate = sdf_.parse(date);
            FastDateFormat formatter = FastDateFormat.getInstance((String)DATUM_ZEIT_FORMAT);
            ret = formatter.format(filmDate);
        }
        catch (ParseException ignored) {
            ret = date;
        }
        return ret;
    }

    public synchronized String getId() {
        return this.metaDaten[4];
    }

    public synchronized void setMetaDaten(String[] data) {
        this.metaDaten = data;
    }

    public int getAge() {
        int ret = 0;
        Date now = new Date(System.currentTimeMillis());
        Date filmDate = this.getAgeAsDate();
        if (filmDate != null && (ret = Math.round((now.getTime() - filmDate.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    private Date getAgeAsDate() {
        String date = this.metaDaten[1];
        this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        Date filmDate = null;
        try {
            filmDate = this.sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return filmDate;
    }

    public synchronized boolean isTooOld() {
        return this.isEmpty() || this.isOlderThan(Const.ALTER_FILMLISTE_SEKUNDEN_FUER_AUTOUPDATE);
    }

    public synchronized boolean isTooOldForDiff() {
        if (this.isEmpty()) {
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09" + ":00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            Date dateFilmliste = this.getAgeAsDate();
            if (dateFilmliste != null) {
                return dateFilmliste.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isOlderThan(long sekunden) {
        long ret = this.getAge();
        if (ret != 0L) {
            logger.info("Die Filmliste ist {} Minuten alt", (Object)(ret / 60L));
        }
        return ret > sekunden;
    }

    public synchronized long countNewFilms() {
        return this.stream().filter(DatenFilm::isNew).count();
    }

    public synchronized void themenLaden() {
        logger.debug(THEME_SEARCH_TEXT);
        LinkedHashSet<String> senderSet = new LinkedHashSet<String>(21);
        senderSet.add("");
        for (DatenFilm film : this) {
            senderSet.add(film.getSender());
        }
        this.sender = senderSet.toArray(new String[0]);
        this.senderList.clear();
        this.senderList.addAll(senderSet);
        senderSet.clear();
        int senderLength = this.sender.length;
        this.themenPerSender = new String[senderLength][];
        TreeSet[] tree = new TreeSet[senderLength];
        HashSet[] hashSet = new HashSet[senderLength];
        for (int i = 0; i < tree.length; ++i) {
            tree[i] = new TreeSet<String>(GermanStringSorter.getInstance());
            tree[i].add("");
            hashSet[i] = new HashSet();
        }
        for (DatenFilm film : this) {
            String filmSender = film.getSender();
            String filmThema = film.arr[2];
            if (!hashSet[0].contains(filmThema)) {
                hashSet[0].add(filmThema);
                tree[0].add(filmThema);
            }
            for (int i = 1; i < senderLength; ++i) {
                if (!filmSender.equals(this.sender[i]) || hashSet[i].contains(filmThema)) continue;
                hashSet[i].add(filmThema);
                tree[i].add(filmThema);
            }
        }
        for (int i = 0; i < this.themenPerSender.length; ++i) {
            this.themenPerSender[i] = tree[i].toArray(new String[0]);
            tree[i].clear();
            hashSet[i].clear();
        }
        logger.debug(THEME_SEARCH_TEXT);
    }
}

