/*
 * Decompiled with CFR 0.152.
 */
package mSearch.daten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import mSearch.daten.DatenFilmCleanupTask;
import mSearch.daten.PooledDatabaseConnection;
import mSearch.tool.DatumFilm;
import mSearch.tool.FileSize;
import mSearch.tool.Functions;
import mSearch.tool.GermanStringSorter;
import mSearch.tool.Log;
import mSearch.tool.MSLong;
import mSearch.tool.MemoryUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import sun.misc.Cleaner;

public class DatenFilm
implements AutoCloseable,
Comparable<DatenFilm> {
    public static final String AUFLOESUNG_NORMAL = "normal";
    public static final String AUFLOESUNG_HD = "hd";
    public static final String AUFLOESUNG_KLEIN = "klein";
    public static final String GEO_DE = "DE";
    public static final String GEO_AT = "AT";
    public static final String GEO_CH = "CH";
    public static final String GEO_EU = "EU";
    public static final String GEO_WELT = "WELT";
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_DATUM = 6;
    public static final int FILM_ZEIT = 7;
    public static final int FILM_DAUER = 8;
    public static final int FILM_GROESSE = 9;
    public static final int FILM_HD = 10;
    public static final int FILM_UT = 11;
    public static final int FILM_GEO = 12;
    public static final int FILM_URL = 13;
    public static final int FILM_ABO_NAME = 14;
    public static final int FILM_URL_SUBTITLE = 15;
    public static final int FILM_URL_KLEIN = 16;
    public static final int FILM_URL_HD = 17;
    public static final int FILM_URL_HISTORY = 18;
    public static final int FILM_DATUM_LONG = 19;
    public static final int FILM_REF = 20;
    public static final int MAX_ELEM = 21;
    public static final int FILM_NEU = 21;
    public static final String[] COLUMN_NAMES = new String[21];
    private static final AtomicInteger FILM_COUNTER = new AtomicInteger(0);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final Logger logger = LogManager.getLogger(DatenFilm.class);
    public static boolean[] spaltenAnzeigen = new boolean[21];
    public final String[] arr = new String[21];
    public DatumFilm datumFilm = new DatumFilm(0L);
    public Object abo = null;
    private MSLong filmSize;
    private long filmLength = 0L;
    private int databaseFilmNumber;
    private boolean neuerFilm = false;
    private Cleaner cleaner;
    private CompletableFuture<Void> descriptionFuture;
    private CompletableFuture<Void> websiteFuture;

    public int getFilmNr() {
        return this.databaseFilmNumber;
    }

    public DatenFilm() {
        this.setupArr();
        this.filmSize = new MSLong(0L);
        this.databaseFilmNumber = FILM_COUNTER.getAndIncrement();
        DatenFilmCleanupTask task = new DatenFilmCleanupTask(this.databaseFilmNumber);
        this.cleaner = Cleaner.create((Object)this, (Runnable)task);
    }

    public MSLong getFilmSize() {
        return this.filmSize;
    }

    private void setupArr() {
        for (int i = 0; i < 21; ++i) {
            this.arr[i] = "";
        }
    }

    public String getTitle() {
        return this.arr[3];
    }

    public void setTitle(String title) {
        this.arr[3] = title;
    }

    public String getThema() {
        return this.arr[2];
    }

    public String getSize() {
        return this.arr[9];
    }

    public String getSender() {
        return this.arr[1];
    }

    public void setSender(String sender) {
        this.arr[1] = sender;
    }

    @Override
    public void close() {
        this.cleaner.clean();
    }

    public String getDescription() {
        String sqlStr;
        try (Connection connection = PooledDatabaseConnection.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT desc FROM description WHERE id = ?");){
            statement.setInt(1, this.databaseFilmNumber);
            if (this.descriptionFuture != null) {
                if (!this.descriptionFuture.isDone()) {
                    this.descriptionFuture.get();
                }
                this.descriptionFuture = null;
            }
            try (ResultSet rs = statement.executeQuery();){
                sqlStr = rs.next() ? rs.getString(1) : "";
            }
        }
        catch (InterruptedException | SQLException | ExecutionException e) {
            logger.error((Object)e);
            sqlStr = "";
        }
        return sqlStr;
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                this.writeDescriptionToDatabase(desc);
            } else {
                this.descriptionFuture = CompletableFuture.runAsync(() -> this.writeDescriptionToDatabase(desc));
            }
        }
    }

    public String getWebsiteLink() {
        String res;
        try (Connection connection = PooledDatabaseConnection.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT link FROM website_links WHERE id = ?");){
            statement.setInt(1, this.databaseFilmNumber);
            if (this.websiteFuture != null) {
                if (!this.websiteFuture.isDone()) {
                    this.websiteFuture.get();
                }
                this.websiteFuture = null;
            }
            try (ResultSet rs = statement.executeQuery();){
                res = rs.next() ? rs.getString(1) : "";
            }
        }
        catch (InterruptedException | SQLException | ExecutionException ex) {
            logger.error((Object)ex);
            res = "";
        }
        return res;
    }

    public void setWebsiteLink(String link) {
        if (link != null && !link.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                this.writeWebsiteLinkToDatabase(link);
            } else {
                this.websiteFuture = CompletableFuture.runAsync(() -> this.writeWebsiteLinkToDatabase(link));
            }
        }
    }

    private void writeWebsiteLinkToDatabase(String link) {
        try (Connection connection2 = PooledDatabaseConnection.getInstance().getConnection();
             PreparedStatement insertStatement = connection2.prepareStatement("INSERT INTO website_links VALUES (?,?)");
             PreparedStatement updateStatement = connection2.prepareStatement("UPDATE website_links SET link=? WHERE id=?");){
            updateStatement.setString(1, link);
            updateStatement.setInt(2, this.databaseFilmNumber);
            updateStatement.executeUpdate();
            insertStatement.setInt(1, this.databaseFilmNumber);
            insertStatement.setString(2, link);
            insertStatement.executeUpdate();
        }
        catch (SQLIntegrityConstraintViolationException connection2) {
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
    }

    private void writeDescriptionToDatabase(String desc) {
        try (Connection connection2 = PooledDatabaseConnection.getInstance().getConnection();
             PreparedStatement insertStatement = connection2.prepareStatement("INSERT INTO description VALUES (?,?)");
             PreparedStatement updateStatement = connection2.prepareStatement("UPDATE description SET desc=? WHERE id =?");){
            String cleanedDesc = this.cleanDescription(desc, this.arr[2], this.getTitle());
            cleanedDesc = StringUtils.replace((String)cleanedDesc, (String)"\n", (String)"<br />");
            updateStatement.setString(1, cleanedDesc);
            updateStatement.setInt(2, this.databaseFilmNumber);
            updateStatement.executeUpdate();
            insertStatement.setInt(1, this.databaseFilmNumber);
            insertStatement.setString(2, cleanedDesc);
            insertStatement.execute();
        }
        catch (SQLIntegrityConstraintViolationException connection2) {
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
    }

    private String cleanDescription(String s, String thema, String titel) {
        if ((s = Functions.removeHtml(s)).startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(thema)) {
            s = s.substring(thema.length()).trim();
        }
        if (s.startsWith("|")) {
            s = s.substring(1).trim();
        }
        if (s.startsWith("Video-Clip")) {
            s = s.substring("Video-Clip".length()).trim();
        }
        if (s.startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(":") || s.startsWith(",") || s.startsWith("\n")) {
            s = s.substring(1).trim();
        }
        if (s.contains("\\\"")) {
            s = StringUtils.replace((String)s, (String)"\\\"", (String)"\"");
        }
        return s;
    }

    public boolean isNew() {
        return this.neuerFilm;
    }

    public void setNew(boolean newFilm) {
        this.neuerFilm = newFilm;
    }

    public String getUrlSubtitle() {
        return this.arr[15];
    }

    public boolean hasSubtitle() {
        return !this.arr[15].isEmpty();
    }

    public String getUrlFuerAufloesung(String aufloesung) {
        String ret;
        switch (aufloesung) {
            case "klein": {
                ret = this.getUrlNormalOrRequested(16);
                break;
            }
            case "hd": {
                ret = this.getUrlNormalOrRequested(17);
                break;
            }
            default: {
                ret = this.arr[13];
            }
        }
        return ret;
    }

    public String getDateigroesse(String url) {
        if (url.equals(this.arr[13])) {
            return this.arr[9];
        }
        return FileSize.laengeString(url);
    }

    public String getUrlHistory() {
        if (this.arr[18].isEmpty()) {
            return this.arr[13];
        }
        return this.arr[18];
    }

    public String getIndex() {
        return (this.getSender() + this.arr[2]).toLowerCase() + this.getUrl();
    }

    public String getUrl() {
        return this.arr[13];
    }

    public boolean isHD() {
        return !this.arr[17].isEmpty();
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.datumFilm = this.datumFilm;
        ret.databaseFilmNumber = this.databaseFilmNumber;
        ret.filmSize = this.filmSize;
        ret.filmLength = this.filmLength;
        ret.abo = this.abo;
        return ret;
    }

    @Override
    public int compareTo(@NotNull DatenFilm other) {
        int ret = sorter.compare(this.getSender(), other.getSender());
        if (ret == 0) {
            return sorter.compare(this.arr[2], other.arr[2]);
        }
        return ret;
    }

    public long getFilmLength() {
        return this.filmLength;
    }

    private void setFilmLength() {
        try {
            this.filmLength = 0L;
            if (!this.arr[8].isEmpty()) {
                String[] parts = this.arr[8].split(":");
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    this.filmLength += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
        }
        catch (Exception ex) {
            this.filmLength = 0L;
            logger.error("Dauer: {}", (Object)this.arr[8], (Object)ex);
        }
    }

    private void setDatum() {
        if (!this.arr[6].isEmpty()) {
            try {
                long l = Long.parseLong(this.arr[19]);
                this.datumFilm = new DatumFilm(l * 1000L);
            }
            catch (Exception ex) {
                logger.error("Datum: {}, Zeit: {}, Datum_LONG: {}", (Object)this.arr[6], (Object)this.arr[7], (Object)this.arr[19], (Object)ex);
                this.datumFilm = new DatumFilm(0L);
                this.arr[6] = "";
                this.arr[7] = "";
            }
        }
    }

    public void init() {
        this.filmSize = new MSLong(this);
        this.setFilmLength();
        this.setDatum();
    }

    private String getUrlNormalOrRequested(int indexUrl) {
        if (!this.arr[indexUrl].isEmpty()) {
            try {
                int indexPipe = this.arr[indexUrl].indexOf(124);
                if (indexPipe < 0) {
                    return this.arr[indexUrl];
                }
                int i = Integer.parseInt(this.arr[indexUrl].substring(0, indexPipe));
                return this.arr[13].substring(0, i) + this.arr[indexUrl].substring(this.arr[indexUrl].indexOf(124) + 1);
            }
            catch (Exception e) {
                Log.errorLog(915236703, e, this.arr[indexUrl]);
            }
        }
        return this.arr[13];
    }

    static {
        DatenFilm.COLUMN_NAMES[0] = "Nr";
        DatenFilm.COLUMN_NAMES[1] = "Sender";
        DatenFilm.COLUMN_NAMES[2] = "Thema";
        DatenFilm.COLUMN_NAMES[3] = "Titel";
        DatenFilm.COLUMN_NAMES[4] = "";
        DatenFilm.COLUMN_NAMES[5] = "";
        DatenFilm.COLUMN_NAMES[6] = "Datum";
        DatenFilm.COLUMN_NAMES[7] = "Zeit";
        DatenFilm.COLUMN_NAMES[8] = "Dauer";
        DatenFilm.COLUMN_NAMES[9] = "Gr\u00f6\u00dfe [MB]";
        DatenFilm.COLUMN_NAMES[10] = "HD";
        DatenFilm.COLUMN_NAMES[11] = "UT";
        DatenFilm.COLUMN_NAMES[12] = "Geo";
        DatenFilm.COLUMN_NAMES[13] = "URL";
        DatenFilm.COLUMN_NAMES[14] = "Abo";
        DatenFilm.COLUMN_NAMES[15] = "URL Untertitel";
        DatenFilm.COLUMN_NAMES[16] = "URL Klein";
        DatenFilm.COLUMN_NAMES[17] = "URL HD";
        DatenFilm.COLUMN_NAMES[18] = "URL History";
        DatenFilm.COLUMN_NAMES[20] = "Ref";
        DatenFilm.COLUMN_NAMES[19] = "DatumL";
        try {
            Database.initializeDatabase();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static class Database {
        private Database() {
        }

        public static void closeDatabase() {
            try (Connection connection = PooledDatabaseConnection.getInstance().getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("DROP TABLE IF EXISTS description");
                statement.executeUpdate("DROP TABLE IF EXISTS website_links");
                statement.executeUpdate("SHUTDOWN COMPACT");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            PooledDatabaseConnection.getInstance().close();
        }

        private static void initializeDatabase() throws SQLException {
            try (Connection connection = PooledDatabaseConnection.getInstance().getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("SET DATABASE TRANSACTION CONTROL MVCC");
                if (!MemoryUtils.isLowMemoryEnvironment()) {
                    statement.executeUpdate("SET FILES CACHE ROWS 100000");
                    statement.executeUpdate("SET FILES CACHE SIZE 50000");
                }
                statement.executeUpdate("DROP TABLE IF EXISTS description");
                statement.executeUpdate("CREATE CACHED TABLE IF NOT EXISTS description (id INTEGER NOT NULL PRIMARY KEY, desc VARCHAR(1024))");
                statement.executeUpdate("DROP TABLE IF EXISTS website_links");
                statement.executeUpdate("CREATE CACHED TABLE IF NOT EXISTS website_links (id INTEGER NOT NULL PRIMARY KEY, link VARCHAR(1024))");
            }
        }
    }
}

