/*
 * Decompiled with CFR 0.152.
 */
package mSearch.tool;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Hash {
    private final MessageDigest md;
    private byte[] bytes;

    public Hash() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not found", e);
        }
    }

    public Hash(byte[] b) {
        this();
        this.update(b);
    }

    public Hash(byte[] b, int off, int len) {
        this();
        this.update(b, off, len);
    }

    public Hash(ByteBuffer bb) {
        this();
        this.update(bb);
    }

    public Hash(String s) {
        this();
        this.update(s);
    }

    public Hash(char c) {
        this();
        this.update(c);
    }

    public Hash(short s) {
        this();
        this.update(s);
    }

    public Hash(int i) {
        this();
        this.update(i);
    }

    public Hash(long l) {
        this();
        this.update(l);
    }

    public Hash(float f) {
        this();
        this.update(f);
    }

    public Hash(double d) {
        this();
        this.update(d);
    }

    public Hash update(byte b) {
        this.checkNotFinished();
        this.md.update(b);
        return this;
    }

    public Hash update(byte[] b) {
        return this.update(b, 0, b.length);
    }

    public Hash update(byte[] b, int off, int len) {
        this.checkNotFinished();
        this.md.update(b, off, len);
        return this;
    }

    public Hash update(ByteBuffer bb) {
        this.checkNotFinished();
        this.md.update(bb);
        return this;
    }

    public Hash update(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                this.update(s.charAt(i));
            }
        }
        return this;
    }

    public Hash update(short s) {
        return this.update((byte)(s >> 8)).update((byte)s);
    }

    public Hash update(char c) {
        return this.update((short)c);
    }

    public Hash update(int i) {
        return this.update((short)(i >> 16)).update((short)i);
    }

    public Hash update(long l) {
        return this.update((int)(l >> 32)).update((int)l);
    }

    public Hash update(float f) {
        return this.update(Float.floatToRawIntBits(f));
    }

    public Hash update(double d) {
        return this.update(Double.doubleToRawLongBits(d));
    }

    public Hash finish() {
        this.bytes = this.md.digest();
        return this;
    }

    public void reset() {
        this.bytes = null;
    }

    public byte[] getBytes() {
        this.ensureFinished();
        return this.bytes;
    }

    public String toHexString() {
        this.ensureFinished();
        StringBuilder sb = new StringBuilder(this.bytes.length * 2);
        for (byte b : this.bytes) {
            sb.append(Character.forDigit(b >> 8 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Hash)) {
            return false;
        }
        Hash hash = (Hash)obj;
        return Arrays.equals(this.getBytes(), hash.getBytes());
    }

    public int hashCode() {
        byte[] b = this.getBytes();
        return b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
    }

    public String toString() {
        return this.toHexString();
    }

    private void checkNotFinished() {
        if (this.bytes != null) {
            throw new IllegalStateException("Hash must be reset before resuse");
        }
    }

    private void ensureFinished() {
        if (this.bytes == null) {
            this.finish();
        }
    }
}

