/*
 * Decompiled with CFR 0.152.
 */
package mSearch.tool;

import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.CodeSource;
import java.util.ResourceBundle;
import mSearch.Const;
import mSearch.daten.DatenFilm;
import mSearch.tool.DbgMsg;
import mSearch.tool.Log;
import mSearch.tool.Version;
import org.apache.commons.lang3.StringEscapeUtils;

public class Functions {
    private static final String RBVERSION = "version";

    public static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        while (text.length() < max) {
            if (addVorne) {
                text = ' ' + text;
                continue;
            }
            text = text + ' ';
        }
        return text;
    }

    public static String minTextLaenge(int max, String text) {
        while (text.length() < max) {
            text = text + ' ';
        }
        return text;
    }

    public static OperatingSystemType getOs() {
        OperatingSystemType os = OperatingSystemType.UNKNOWN;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            if (System.getenv("ProgramFiles(x86)") != null) {
                os = OperatingSystemType.WIN64;
            } else if (System.getenv("ProgramFiles") != null) {
                os = OperatingSystemType.WIN32;
            }
        } else if (SystemInfo.isLinux()) {
            os = OperatingSystemType.LINUX;
        } else if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
            os = OperatingSystemType.LINUX;
        } else if (SystemInfo.isMacOSX()) {
            os = OperatingSystemType.MAC;
        }
        return os;
    }

    public static String getOsString() {
        return Functions.getOs().toString();
    }

    public static String getPathJar() {
        String pFilePath = "version.properties";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Const.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception cS) {}
        } else {
            DbgMsg.print("getPath");
        }
        String s = propFile.getAbsolutePath().replace(pFilePath, "");
        if (!s.endsWith(File.separator)) {
            s = s + File.separator;
        }
        if (s.endsWith("/lib/")) {
            s = s.replace("/lib/", "");
        }
        return s;
    }

    public static String getProgVersionString() {
        return " [Vers.: " + Functions.getProgVersion().toString() + ']';
    }

    public static String[] getJavaVersion() {
        String[] ret = new String[4];
        int i = 0;
        ret[i++] = "Vendor: " + System.getProperty("java.vendor");
        ret[i++] = "VMname: " + System.getProperty("java.vm.name");
        ret[i++] = "Version: " + System.getProperty("java.version");
        ret[i++] = "Runtimeversion: " + System.getProperty("java.runtime.version");
        return ret;
    }

    public static String getCompileDate() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(propToken)) {
                msg = rb.getString(propToken);
            }
        }
        catch (Exception e) {
            Log.errorLog(807293847, e);
        }
        return msg;
    }

    public static Version getProgVersion() {
        String TOKEN_VERSION = "VERSION";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(TOKEN_VERSION)) {
                return new Version(rb.getString(TOKEN_VERSION));
            }
        }
        catch (Exception e) {
            Log.errorLog(134679898, e);
        }
        return new Version("");
    }

    @Deprecated
    public static String getBuildNr() {
        String TOKEN_VERSION = "VERSION";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(RBVERSION);
            if (rb.containsKey(TOKEN_VERSION)) {
                return new Version(rb.getString(TOKEN_VERSION)).toString();
            }
        }
        catch (Exception e) {
            Log.errorLog(134679898, e);
        }
        return new Version("").toString();
    }

    private static void unescapeThema(DatenFilm film) {
        film.arr[2] = StringEscapeUtils.unescapeXml((String)film.arr[2]);
        film.arr[2] = StringEscapeUtils.unescapeHtml4((String)film.arr[2]);
        film.arr[2] = StringEscapeUtils.unescapeJava((String)film.arr[2]);
    }

    private static void unescapeTitel(DatenFilm film) {
        film.arr[3] = StringEscapeUtils.unescapeXml((String)film.arr[3]);
        film.arr[3] = StringEscapeUtils.unescapeHtml4((String)film.arr[3]);
        film.arr[3] = StringEscapeUtils.unescapeJava((String)film.arr[3]);
    }

    private static void unescapeDescription(DatenFilm film) {
        film.arr[12] = StringEscapeUtils.unescapeXml((String)film.arr[12]);
        film.arr[12] = StringEscapeUtils.unescapeHtml4((String)film.arr[12]);
        film.arr[12] = StringEscapeUtils.unescapeJava((String)film.arr[12]);
        film.arr[12] = Functions.removeHtml(film.arr[12]);
    }

    private static void replaceText(DatenFilm film) {
        film.arr[2] = film.arr[2].replace("\\", "/").trim();
        film.arr[3] = film.arr[3].replace("\\", "/").trim();
        film.arr[12] = film.arr[12].replace("\\", "/").trim();
    }

    public static void unescape(DatenFilm film) {
        Functions.unescapeThema(film);
        Functions.unescapeTitel(film);
        Functions.unescapeDescription(film);
        Functions.replaceText(film);
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null) {
            if (pfad1.isEmpty()) {
                ret = pfad2;
            } else if (pfad2.isEmpty()) {
                ret = pfad1;
            } else if (!pfad1.isEmpty() && !pfad2.isEmpty()) {
                ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
                ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
            }
        }
        if (ret.isEmpty()) {
            Log.errorLog(283946015, pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String addUrl(String u1, String u2) {
        if (u1.endsWith("/")) {
            return u1 + u2;
        }
        return u1 + '/' + u2;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") || dateiUrl.startsWith("www");
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty()) {
            ret = pfad.substring(pfad.lastIndexOf(47) + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf(38));
        }
        if (ret.isEmpty()) {
            Log.errorLog(395019631, pfad);
        }
        return ret;
    }

    public static String removeHtml(String in) {
        return in.replaceAll("\\<.*?>", "");
    }

    public static enum OperatingSystemType {
        UNKNOWN(""),
        WIN32("Windows"),
        WIN64("Windows"),
        LINUX("Linux"),
        MAC("Mac");

        private final String name;

        private OperatingSystemType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

