/*
 * Decompiled with CFR 0.152.
 */
package mSearch.daten;

import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import mSearch.daten.DatenFilm;
import mSearch.tool.Duration;
import mSearch.tool.FileSize;
import mSearch.tool.Functions;
import mSearch.tool.GermanStringSorter;
import mSearch.tool.Log;
import org.apache.commons.lang3.time.FastDateFormat;

public class ListeFilme
extends ArrayList<DatenFilm> {
    public static final String THEMA_LIVE = "Livestream";
    public static final String FILMLISTE = "Filmliste";
    public static final String FILMLISTE_DATUM = "Filmliste-Datum";
    public static final int FILMLISTE_DATUM_NR = 0;
    public static final String FILMLISTE_DATUM_GMT = "Filmliste-Datum-GMT";
    public static final int FILMLISTE_DATUM_GMT_NR = 1;
    public static final String FILMLISTE_VERSION = "Filmliste-Version";
    public static final int FILMLISTE_VERSION_NR = 2;
    public static final String FILMLISTE_PROGRAMM = "Filmliste-Programm";
    public static final int FILMLISTE_PRGRAMM_NR = 3;
    public static final String FILMLISTE_ID = "Filmliste-Id";
    public static final int FILMLISTE_ID_NR = 4;
    public static final int MAX_ELEM = 5;
    public static final String[] COLUMN_NAMES = new String[]{"Filmliste-Datum", "Filmliste-Datum-GMT", "Filmliste-Version", "Filmliste-Programm", "Filmliste-Id"};
    public int nr = 1;
    public String[] metaDaten = new String[]{"", "", "", "", ""};
    private static final String DATUM_ZEIT_FORMAT = "dd.MM.yyyy, HH:mm";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    public String[] sender = new String[]{""};
    public String[][] themenPerSender = new String[][]{{""}};
    public boolean neueFilme = false;
    private final Collection<String> indexes = new ConcurrentSkipListSet<String>();
    private static final String THEME_SEARCH_TEXT = "Themen in Filmliste suchen";

    public synchronized boolean importFilmliste(DatenFilm film) {
        film.nr = this.nr++;
        return this.addInit(film);
    }

    public synchronized boolean addFilmVomSender(DatenFilm film) {
        Functions.unescape(film);
        return !this.indexes.contains(film.getIndex()) && this.addInit(film);
    }

    private void addHash(DatenFilm f, HashSet<String> hash, boolean index) {
        if (f.arr[1].equals("KiKA")) {
            hash.add(f.arr[2] + f.arr[3]);
        } else if (index) {
            hash.add(f.getIndex());
        } else {
            hash.add(f.getUrl());
        }
    }

    public synchronized void updateListe(ListeFilme listeEinsortieren, boolean index, boolean ersetzen) {
        HashSet hash = new HashSet(listeEinsortieren.size() + 1, 1.0f);
        if (ersetzen) {
            listeEinsortieren.forEach((? super E f) -> this.addHash((DatenFilm)f, hash, index));
            Iterator it = this.iterator();
            while (it.hasNext()) {
                DatenFilm f2 = (DatenFilm)it.next();
                if (f2.arr[1].equals("KiKA")) {
                    if (!hash.contains(f2.arr[2] + f2.arr[3])) continue;
                    it.remove();
                    continue;
                }
                if (index) {
                    if (!hash.contains(f2.getIndex())) continue;
                    it.remove();
                    continue;
                }
                if (!hash.contains(f2.getUrl())) continue;
                it.remove();
            }
            listeEinsortieren.forEach(this::addInit);
        } else {
            this.forEach((? super E f) -> this.addHash((DatenFilm)f, hash, index));
            for (DatenFilm f3 : listeEinsortieren) {
                if (f3.arr[1].equals("KiKA")) {
                    if (hash.contains(f3.arr[2] + f3.arr[3])) continue;
                    this.addInit(f3);
                    continue;
                }
                if (index) {
                    if (hash.contains(f3.getIndex())) continue;
                    this.addInit(f3);
                    continue;
                }
                if (hash.contains(f3.getUrl())) continue;
                this.addInit(f3);
            }
        }
        hash.clear();
    }

    private boolean addInit(DatenFilm film) {
        film.init();
        return this.add(film);
    }

    @Override
    public boolean add(DatenFilm aFilm) {
        this.indexes.add(aFilm.getIndex());
        return super.add(aFilm);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        this.neueFilme = false;
        this.indexes.clear();
        super.clear();
    }

    public synchronized void check() {
        for (DatenFilm film : this) {
            String s = film.arr[12];
            film.arr[12] = Functions.removeHtml(film.arr[12]);
            if (!s.equals(film.arr[12])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[12]);
            }
            s = film.arr[2];
            film.arr[2] = Functions.removeHtml(film.arr[2]);
            if (!s.equals(film.arr[2])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[2]);
            }
            s = film.arr[3];
            film.arr[3] = Functions.removeHtml(film.arr[3]);
            if (!s.equals(film.arr[3])) {
                System.out.println("---------------------");
                System.out.println(s);
                System.out.println(film.arr[3]);
            }
            if (!film.arr[14].contains(" ")) continue;
            System.out.println(film.arr[14]);
        }
    }

    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (DatenFilm film : this) {
            film.nr = i++;
        }
    }

    public synchronized void setMeta(ListeFilme listeFilme) {
        System.arraycopy(listeFilme.metaDaten, 0, this.metaDaten, 0, 5);
    }

    public synchronized ListeFilme neueFilme(ListeFilme orgListe) {
        String s;
        ListeFilme ret = new ListeFilme();
        HashSet<String> hashSet = new HashSet<String>(orgListe.size() + 1, 1.0f);
        for (DatenFilm film : orgListe) {
            s = film.arr[1] + film.arr[2] + film.arr[3] + film.arr[14];
            hashSet.add(s);
        }
        for (DatenFilm film : this) {
            s = film.arr[1] + film.arr[2] + film.arr[3] + film.arr[14];
            if (hashSet.contains(s)) continue;
            ret.add(film);
        }
        hashSet.clear();
        ret.metaDaten = this.metaDaten;
        return ret;
    }

    @Deprecated
    public String getFileSizeUrl(String url) {
        String res;
        Optional<DatenFilm> opt = this.parallelStream().filter(f -> f.arr[14].equals(url)).findAny();
        if (opt.isPresent()) {
            DatenFilm film = opt.get();
            res = !film.arr[9].isEmpty() ? film.arr[9] : FileSize.laengeString(url);
        } else {
            res = FileSize.laengeString(url);
        }
        return res;
    }

    public synchronized void deleteAllFilms(String sender) {
        this.removeIf(film -> film.arr[1].equalsIgnoreCase(sender));
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        Optional<DatenFilm> opt = this.parallelStream().filter(f -> f.arr[14].equalsIgnoreCase(url)).findAny();
        return opt.orElse(null);
    }

    public synchronized void checkThema(String sender, LinkedList<String> liste, String thema) {
        this.stream().filter(film -> film.arr[1].equals(sender)).filter(film -> !film.arr[2].equals(THEMA_LIVE) && !liste.contains(film.arr[2])).forEach((? super T film) -> {
            film.arr[2] = thema;
        });
    }

    public synchronized void getThema(String sender, LinkedList<String> liste) {
        this.stream().filter(film -> film.arr[1].equals(sender)).filter(film -> !liste.contains(film.arr[2])).forEach((? super T film) -> liste.add(film.arr[2]));
    }

    public synchronized DatenFilm getFilmByUrl_klein_hoch_hd(String url) {
        DatenFilm ret = null;
        for (DatenFilm f : this) {
            if (f.arr[14].equals(url)) {
                ret = f;
                break;
            }
            if (f.getUrlFuerAufloesung("hd").equals(url)) {
                ret = f;
                break;
            }
            if (!f.getUrlFuerAufloesung("klein").equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized String genDate() {
        String ret;
        if (this.metaDaten[1].isEmpty()) {
            ret = this.metaDaten[0];
        } else {
            String date = this.metaDaten[1];
            SimpleDateFormat sdf_ = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
            sdf_.setTimeZone(new SimpleTimeZone(2, "UTC"));
            Date filmDate = null;
            try {
                filmDate = sdf_.parse(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (filmDate == null) {
                ret = this.metaDaten[1];
            } else {
                FastDateFormat formatter = FastDateFormat.getInstance((String)DATUM_ZEIT_FORMAT);
                ret = formatter.format(filmDate);
            }
        }
        return ret;
    }

    public synchronized String getId() {
        return this.metaDaten[4];
    }

    public int getAge() {
        int ret = 0;
        Date now = new Date(System.currentTimeMillis());
        Date filmDate = this.getAgeAsDate();
        if (filmDate != null && (ret = Math.round((now.getTime() - filmDate.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    public Date getAgeAsDate() {
        String date;
        if (!this.metaDaten[1].isEmpty()) {
            date = this.metaDaten[1];
            this.sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        } else {
            date = this.metaDaten[0];
        }
        Date filmDate = null;
        try {
            filmDate = this.sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return filmDate;
    }

    public synchronized boolean isTooOld() {
        return this.isEmpty() || this.isOlderThan(10800);
    }

    public synchronized boolean isTooOldForDiff() {
        if (this.isEmpty()) {
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09" + ":00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            Date dateFilmliste = this.getAgeAsDate();
            if (dateFilmliste != null) {
                return dateFilmliste.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isOlderThan(int sekunden) {
        int ret = this.getAge();
        if (ret != 0) {
            Log.sysLog("Die Filmliste ist " + ret / 60 + " Minuten alt");
        }
        return ret > sekunden;
    }

    public synchronized void writeMetaData() {
        for (int i = 0; i < this.metaDaten.length; ++i) {
            this.metaDaten[i] = "";
        }
        this.metaDaten[0] = this.getJetzt_ddMMyyyy_HHmm();
        this.metaDaten[1] = this.getJetzt_ddMMyyyy_HHmm_gmt();
        this.metaDaten[4] = this.createChecksum(this.metaDaten[1]);
        this.metaDaten[2] = "3";
        this.metaDaten[3] = "MSearch" + Functions.getProgVersionString();
    }

    private String createChecksum(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] digest;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            for (byte b : digest = md.digest()) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private String getJetzt_ddMMyyyy_HHmm() {
        FastDateFormat formatter = FastDateFormat.getInstance((String)DATUM_ZEIT_FORMAT);
        return formatter.format(new Date());
    }

    private String getJetzt_ddMMyyyy_HHmm_gmt() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATUM_ZEIT_FORMAT);
        formatter.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return formatter.format(new Date());
    }

    public synchronized long countNewFilms() {
        return this.stream().filter(DatenFilm::isNew).count();
    }

    public synchronized void themenLaden() {
        Duration.counterStart(THEME_SEARCH_TEXT);
        LinkedHashSet<String> senderSet = new LinkedHashSet<String>(21);
        senderSet.add("");
        for (DatenFilm film : this) {
            senderSet.add(film.arr[1]);
        }
        this.sender = senderSet.toArray(new String[senderSet.size()]);
        senderSet.clear();
        int senderLength = this.sender.length;
        this.themenPerSender = new String[senderLength][];
        TreeSet[] tree = new TreeSet[senderLength];
        HashSet[] hashSet = new HashSet[senderLength];
        for (int i = 0; i < tree.length; ++i) {
            tree[i] = new TreeSet<String>(GermanStringSorter.getInstance());
            tree[i].add("");
            hashSet[i] = new HashSet();
        }
        for (DatenFilm film : this) {
            String filmSender = film.arr[1];
            String filmThema = film.arr[2];
            if (!hashSet[0].contains(filmThema)) {
                hashSet[0].add(filmThema);
                tree[0].add(filmThema);
            }
            for (int i = 1; i < senderLength; ++i) {
                if (!filmSender.equals(this.sender[i]) || hashSet[i].contains(filmThema)) continue;
                hashSet[i].add(filmThema);
                tree[i].add(filmThema);
            }
        }
        for (int i = 0; i < this.themenPerSender.length; ++i) {
            this.themenPerSender[i] = tree[i].toArray(new String[tree[i].size()]);
            tree[i].clear();
            hashSet[i].clear();
        }
        Duration.counterStop(THEME_SEARCH_TEXT);
    }
}

