/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.server;

import de.maximilianbrandau.intercom.AuthenticationHandler;
import de.maximilianbrandau.intercom.codec.packets.AuthPacket;
import de.maximilianbrandau.intercom.codec.packets.PingPacket;
import de.maximilianbrandau.intercom.codec.packets.RequestPacket;
import de.maximilianbrandau.intercom.server.IntercomRequest;
import de.maximilianbrandau.intercom.server.IntercomRequestHandler;
import de.maximilianbrandau.intercom.server.IntercomResponse;
import de.maximilianbrandau.intercom.server.IntercomServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;

public class IntercomServerHandler<T>
extends ChannelInboundHandlerAdapter {
    private final IntercomServer<T> server;
    private boolean authenticated = false;

    public IntercomServerHandler(IntercomServer<T> server) {
        this.server = server;
    }

    public void channelActive(ChannelHandlerContext ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            RequestPacket packet;
            IntercomRequestHandler handler;
            if (msg instanceof PingPacket) {
                ctx.writeAndFlush(msg);
                return;
            }
            if (msg instanceof AuthPacket) {
                AuthPacket packet2 = (AuthPacket)msg;
                AuthenticationHandler authenticationHandler = this.server.authenticationHandler;
                if (authenticationHandler != null) {
                    this.authenticated = authenticationHandler.authenticate(this.server.authenticationHandler.decode(packet2.getBuffer()));
                }
                return;
            }
            if (msg instanceof RequestPacket && (handler = this.server.requestHandlers.get((packet = (RequestPacket)msg).getEvent())) != null) {
                IntercomRequest request = new IntercomRequest(System.currentTimeMillis(), (InetSocketAddress)ctx.channel().remoteAddress(), this.authenticated, packet.getRequestId(), packet.getEvent(), this.server.intercomCodec.decode(packet.getData()));
                IntercomResponse<T> response = new IntercomResponse<T>(this.server, ctx, request);
                handler.handleRequest(request, response);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
    }
}

