/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.server;

import de.maximilianbrandau.intercom.AlreadyClosedException;
import de.maximilianbrandau.intercom.AuthenticationHandler;
import de.maximilianbrandau.intercom.codec.IntercomCodec;
import de.maximilianbrandau.intercom.codec.NettyCodec;
import de.maximilianbrandau.intercom.codec.packets.PushPacket;
import de.maximilianbrandau.intercom.server.IntercomRequestHandler;
import de.maximilianbrandau.intercom.server.IntercomServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.net.ssl.SSLException;

public class IntercomServer<T> {
    final HashMap<String, IntercomRequestHandler<T>> requestHandlers;
    final AuthenticationHandler authenticationHandler;
    final IntercomCodec<T> intercomCodec;
    private final ChannelFuture channelFuture;
    private final Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private boolean closed = false;

    private IntercomServer(String host, int port, boolean ssl, AuthenticationHandler authenticationHandler, IntercomCodec<T> intercomCodec) throws SSLException, CertificateException {
        SslContext sslCtx;
        this.authenticationHandler = authenticationHandler;
        this.intercomCodec = intercomCodec;
        if (ssl) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        } else {
            sslCtx = null;
        }
        this.bossGroup = new EpollEventLoopGroup(1);
        this.workerGroup = new EpollEventLoopGroup();
        this.requestHandlers = new HashMap();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                }
                p.addLast("codec", (ChannelHandler)new NettyCodec());
                p.addLast("handler", new IntercomServerHandler(IntercomServer.this));
            }
        });
        ChannelFuture bindFuture = host == null ? b.bind(port) : b.bind(host, port);
        try {
            bindFuture = bindFuture.sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.channel = bindFuture.channel();
        this.channelFuture = bindFuture.channel().closeFuture();
    }

    public void close() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Server");
        }
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().channel().closeFuture();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void push(String event) {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Server");
        }
        this.channel.writeAndFlush((Object)new PushPacket(event));
    }

    public void addHandler(String event, IntercomRequestHandler<T> requestHandler) {
        this.requestHandlers.put(event, requestHandler);
    }

    public static class Builder {
        private String host = null;
        private int port;
        private boolean ssl = true;
        private AuthenticationHandler authenticationHandler = null;

        public Builder(int port) {
            this.port = port;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public <A> Builder authenticationHandler(AuthenticationHandler<A> authenticationHandler) {
            this.authenticationHandler = authenticationHandler;
            return this;
        }

        public <T> IntercomServer<T> build(IntercomCodec<T> intercomCodec) throws SSLException, CertificateException {
            return new IntercomServer(this.host, this.port, this.ssl, this.authenticationHandler, intercomCodec);
        }
    }
}

