/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.server;

import de.maximilianbrandau.intercom.codec.IntercomByteBuf;
import de.maximilianbrandau.intercom.codec.packets.ResponsePacket;
import de.maximilianbrandau.intercom.server.IntercomRequest;
import de.maximilianbrandau.intercom.server.IntercomServer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;

public class IntercomResponse<T> {
    private final IntercomServer<T> server;
    private final ChannelHandlerContext ctx;
    private final IntercomRequest<T> request;
    private short status = (short)200;
    private T data;

    public IntercomResponse(IntercomServer<T> server, ChannelHandlerContext ctx, IntercomRequest<T> request) {
        this.server = server;
        this.ctx = ctx;
        this.request = request;
    }

    public IntercomRequest<T> getRequest() {
        return this.request;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isOk() {
        return this.status == 200;
    }

    public void setOk(boolean ok) {
        this.status = (short)(ok ? 200 : 500);
    }

    public void end() {
        IntercomByteBuf dataBuffer = new IntercomByteBuf(Unpooled.buffer());
        this.server.intercomCodec.encode(this.getData(), dataBuffer);
        this.ctx.writeAndFlush((Object)new ResponsePacket(this.getRequest().getRequestId(), this.status, dataBuffer));
    }
}

