/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.codec.packets;

import de.maximilianbrandau.intercom.codec.IntercomByteBuf;
import de.maximilianbrandau.intercom.codec.IntercomPacket;
import de.maximilianbrandau.intercom.codec.PacketType;

public class ResponsePacket
extends IntercomPacket {
    private String requestId;
    private short status;
    private IntercomByteBuf data;

    public ResponsePacket(String requestId, short status, IntercomByteBuf data) {
        this.requestId = requestId;
        this.status = status;
        this.data = data;
    }

    public ResponsePacket() {
    }

    public String getRequestId() {
        return this.requestId;
    }

    public short getStatus() {
        return this.status;
    }

    public IntercomByteBuf getData() {
        return this.data;
    }

    @Override
    public PacketType getPacketType() {
        return PacketType.RESPONSE;
    }

    @Override
    public void encode(IntercomByteBuf byteBuffer) {
        byteBuffer.writeUtf8(this.requestId);
        byteBuffer.writeShort(this.status);
        byteBuffer.writeInt(this.data.writerIndex());
        byteBuffer.writeBytes(this.data);
    }

    @Override
    public void decode(IntercomByteBuf byteBuffer) {
        this.requestId = byteBuffer.readUtf8();
        this.status = byteBuffer.readShort();
        this.data = new IntercomByteBuf(byteBuffer.readRetainedSlice(byteBuffer.readInt()));
    }
}

