/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.codec.packets;

import de.maximilianbrandau.intercom.codec.IntercomByteBuf;
import de.maximilianbrandau.intercom.codec.IntercomPacket;
import de.maximilianbrandau.intercom.codec.PacketType;

public class RequestPacket
extends IntercomPacket {
    private String requestId;
    private String event;
    private IntercomByteBuf data;

    public RequestPacket(String requestId, String event, IntercomByteBuf data) {
        this.requestId = requestId;
        this.event = event;
        this.data = data;
    }

    public RequestPacket() {
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getEvent() {
        return this.event;
    }

    public IntercomByteBuf getData() {
        return this.data;
    }

    @Override
    public PacketType getPacketType() {
        return PacketType.REQUEST;
    }

    @Override
    public void encode(IntercomByteBuf byteBuffer) {
        byteBuffer.writeUtf8(this.requestId);
        byteBuffer.writeUtf8(this.event);
        byteBuffer.writeInt(this.data.writerIndex());
        byteBuffer.writeBytes(this.data);
    }

    @Override
    public void decode(IntercomByteBuf byteBuffer) {
        this.requestId = byteBuffer.readUtf8();
        this.event = byteBuffer.readUtf8();
        this.data = new IntercomByteBuf(byteBuffer.readRetainedSlice(byteBuffer.readInt()));
    }
}

