/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.codec;

import de.maximilianbrandau.intercom.codec.IntercomByteBuf;
import de.maximilianbrandau.intercom.codec.IntercomPacket;
import de.maximilianbrandau.intercom.codec.PacketType;
import de.maximilianbrandau.intercom.codec.packets.AuthPacket;
import de.maximilianbrandau.intercom.codec.packets.AuthResponsePacket;
import de.maximilianbrandau.intercom.codec.packets.PingPacket;
import de.maximilianbrandau.intercom.codec.packets.PushPacket;
import de.maximilianbrandau.intercom.codec.packets.RequestPacket;
import de.maximilianbrandau.intercom.codec.packets.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;

public class NettyCodec
extends ByteToMessageCodec<IntercomPacket> {
    private static IntercomPacket decode(ByteBuf byteBuffer) {
        PacketType packetType = PacketType.getById(byteBuffer.readByte());
        int length = byteBuffer.readInt();
        ByteBuf data = byteBuffer.readSlice(length);
        IntercomPacket packet = null;
        assert (packetType != null);
        switch (packetType) {
            case AUTH: {
                packet = new AuthPacket();
                break;
            }
            case AUTH_RESPONSE: {
                packet = new AuthResponsePacket();
                break;
            }
            case PING: {
                packet = new PingPacket();
                break;
            }
            case REQUEST: {
                packet = new RequestPacket();
                break;
            }
            case RESPONSE: {
                packet = new ResponsePacket();
                break;
            }
            case PUSH: {
                packet = new PushPacket();
            }
        }
        ((IntercomPacket)packet).decode(new IntercomByteBuf(data));
        return packet;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, IntercomPacket intercomPacket, ByteBuf byteBuf) {
        ByteBuf dataBuffer = Unpooled.buffer();
        intercomPacket.encode(new IntercomByteBuf(dataBuffer));
        byteBuf.writeByte((int)intercomPacket.getPacketType().getId());
        byteBuf.writeInt(dataBuffer.writerIndex());
        byteBuf.writeBytes(dataBuffer);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        list.add(NettyCodec.decode(byteBuf));
    }
}

