/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.client;

import de.maximilianbrandau.intercom.client.IntercomClient;
import de.maximilianbrandau.intercom.client.IntercomResponse;
import de.maximilianbrandau.intercom.client.SentRequest;
import de.maximilianbrandau.intercom.codec.packets.AuthResponsePacket;
import de.maximilianbrandau.intercom.codec.packets.PingPacket;
import de.maximilianbrandau.intercom.codec.packets.PushPacket;
import de.maximilianbrandau.intercom.codec.packets.ResponsePacket;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.TimeUnit;

public class IntercomClientHandler<T>
extends ChannelInboundHandlerAdapter {
    private static final long PING_DELAY = 5000L;
    private final IntercomClient<T> client;

    public IntercomClientHandler(IntercomClient<T> client) {
        this.client = client;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.client.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ResponsePacket packet;
        SentRequest sentRequest;
        long receiveTime = System.currentTimeMillis();
        if (msg instanceof AuthResponsePacket) {
            // empty if block
        }
        if (msg instanceof PingPacket) {
            this.client.ping = (int)(System.currentTimeMillis() - ((PingPacket)msg).getStartTime());
            this.client.eventLoopGroup.schedule(this.client::ping, 5000L, TimeUnit.MILLISECONDS);
        }
        if (msg instanceof ResponsePacket && (sentRequest = this.client.sentRequests.get((packet = (ResponsePacket)msg).getRequestId())) != null) {
            try {
                IntercomResponse response = new IntercomResponse(packet.getStatus(), receiveTime - sentRequest.getStartTime(), this.client.intercomCodec.decode(packet.getData()));
                sentRequest.getFuture().complete(response);
            }
            catch (Throwable t) {
                sentRequest.getFuture().completeExceptionally(t);
            }
            finally {
                sentRequest.getTimeoutFuture().cancel(false);
                this.client.sentRequests.remove(packet.getRequestId());
            }
        }
        if (msg instanceof PushPacket) {
            PushPacket pushPacket = (PushPacket)msg;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.client.connect();
    }
}

