/*
 * Decompiled with CFR 0.152.
 */
package de.maximilianbrandau.intercom.client;

import de.maximilianbrandau.intercom.AlreadyClosedException;
import de.maximilianbrandau.intercom.client.IntercomClientHandler;
import de.maximilianbrandau.intercom.client.IntercomRequest;
import de.maximilianbrandau.intercom.client.SentRequest;
import de.maximilianbrandau.intercom.codec.IntercomCodec;
import de.maximilianbrandau.intercom.codec.NettyCodec;
import de.maximilianbrandau.intercom.codec.packets.PingPacket;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class IntercomClient<T> {
    private static final long RECONNECT_DELAY = 5000L;
    final EventLoopGroup eventLoopGroup;
    final HashMap<String, SentRequest<T>> sentRequests;
    final IntercomCodec<T> intercomCodec;
    private final long requestTimeout;
    private final Bootstrap bootstrap;
    private final String host;
    private final int port;
    int ping = -1;
    private ChannelFuture channelFuture;
    private Channel channel;
    private boolean closed = false;
    private long requestId = Long.MIN_VALUE;

    private IntercomClient(final String host, final int port, boolean ssl, long requestTimeout, IntercomCodec<T> intercomCodec) throws SSLException {
        this.host = host;
        this.port = port;
        this.requestTimeout = requestTimeout;
        this.intercomCodec = intercomCodec;
        final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        this.sentRequests = new HashMap();
        this.eventLoopGroup = new EpollEventLoopGroup();
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(EpollSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                }
                p.addLast("codec", (ChannelHandler)new NettyCodec());
                p.addLast("handler", new IntercomClientHandler(IntercomClient.this));
            }
        });
        this.connect();
    }

    protected void connect() {
        block3: {
            if (this.isClosed()) {
                throw new RuntimeException("Client is already closed");
            }
            try {
                this.channelFuture = this.bootstrap.connect(this.host, this.port).sync().await();
                this.channel = this.channelFuture.channel();
            }
            catch (Exception e) {
                if (this.isClosed()) break block3;
                e.printStackTrace();
                this.eventLoopGroup.schedule(this::connect, 5000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void close() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Client");
        }
        if (this.channelFuture != null) {
            try {
                this.channelFuture.channel().close().channel().closeFuture().sync();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.eventLoopGroup.shutdownGracefully();
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void authenticate() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Client");
        }
    }

    String requestId() {
        return String.valueOf(this.requestId++);
    }

    public IntercomRequest.Builder<T> request(String event) {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Client");
        }
        return new IntercomRequest.Builder(this, event, this.channel);
    }

    public int getPing() {
        return this.ping;
    }

    void ping() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("Client");
        }
        if (this.channel != null) {
            this.channel.writeAndFlush((Object)new PingPacket(System.currentTimeMillis(), this.ping));
        }
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public static class Builder {
        private String host;
        private int port;
        private boolean ssl = true;
        private long requestTimeout = 30000L;

        public Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder requestTimeout(long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public <T> IntercomClient<T> build(IntercomCodec<T> intercomCodec) throws SSLException {
            return new IntercomClient(this.host, this.port, this.ssl, this.requestTimeout, intercomCodec);
        }
    }
}

