/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.streamervarocore.UTils;

import de.maxbossing.maxapi.UTils.ConfigManager;
import de.maxbossing.streamervarocore.Enums.StrikeEventType;
import de.maxbossing.streamervarocore.Events.PlayerStrikeChangeEvent;
import de.maxbossing.streamervarocore.StreamerVaroCore;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class Strikes {
    private static ConfigManager strikes = new ConfigManager((JavaPlugin)StreamerVaroCore.getInstance(), "strikes.yml");
    private static ConfigManager config = new ConfigManager((JavaPlugin)StreamerVaroCore.getInstance(), "config.yml");

    public static boolean hasStrikes(UUID uuid) {
        return strikes.getInt(uuid.toString()) != 0;
    }

    public static int getStrikes(UUID uuid) {
        if (!Strikes.hasStrikes(uuid)) {
            return 0;
        }
        return strikes.getInt(uuid.toString());
    }

    public static boolean setStrikes(UUID uuid, int newstrikes) {
        try {
            strikes.set(uuid.toString(), (Object)newstrikes, true);
        }
        catch (Exception e) {
            return false;
        }
        PlayerStrikeChangeEvent event = new PlayerStrikeChangeEvent(Bukkit.getPlayer((UUID)uuid), StrikeEventType.SET_STRIKE, Strikes.getStrikes(uuid));
        Bukkit.getPluginManager().callEvent((Event)event);
        return true;
    }

    public static boolean incrementStrikes(UUID uuid, int increment) {
        try {
            strikes.set(uuid.toString(), (Object)(strikes.getInt(uuid.toString()) + increment), true);
        }
        catch (Exception e) {
            return false;
        }
        PlayerStrikeChangeEvent event = new PlayerStrikeChangeEvent(Bukkit.getPlayer((UUID)uuid), StrikeEventType.ADD_STRIKE, Strikes.getStrikes(uuid));
        Bukkit.getPluginManager().callEvent((Event)event);
        return true;
    }

    public static boolean decrementStrikes(UUID uuid, int decrement) {
        try {
            strikes.set(uuid.toString(), (Object)(strikes.getInt(uuid.toString()) - decrement), true);
        }
        catch (Exception e) {
            return false;
        }
        PlayerStrikeChangeEvent event = new PlayerStrikeChangeEvent(Bukkit.getPlayer((UUID)uuid), StrikeEventType.REMOVE_STRIKE, Strikes.getStrikes(uuid));
        Bukkit.getPluginManager().callEvent((Event)event);
        return true;
    }

    public static int getMaxStrikes() {
        return config.getInt("maxstrikes");
    }

    public static boolean setMaxStrikes(int maxStrikes) {
        try {
            config.set("maxstrikes", (Object)maxStrikes, true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

