package de.maxbossing.streamervarocore;

import de.maxbossing.maxapi.Constants.Prefixes;
import de.maxbossing.maxapi.UTils.ConfigManager;
import de.maxbossing.streamervarocore.UTils.UTils;
import org.bukkit.ChatColor;
import org.bukkit.plugin.java.JavaPlugin;
import java.io.File;

public final class StreamerVaroCore extends JavaPlugin {

    /*Prefixes*/
    public static final String MAIN = Prefixes.MAIN("StreamerVaro");
    public static final String ERROR = Prefixes.ERROR("StreamerVaro");
    public static final String WARNING = Prefixes.WARNING("StreamerVaro");
    public static final String DEBUG = Prefixes.DEBUG("StreamerVaro");
    public static final String CONSOLE = "[StreamerVaro] ";

    /*Main Instance*/
    private static StreamerVaroCore instance;


    /*onEnable*/
    @Override
    public void onEnable() {

        instance = this;

        config();

        UTils.log(" ____  _    \n" +
                "/ ___\\/ \\ |\\\n" +
                "|    \\| | //\n" +
                "\\___ || \\//  Streamer Varo Core v1.0.0\n" +
                "\\____/\\__/   by Max\n", null);

        UTils.log("Plugin loaded", ChatColor.GREEN);



        UTils.log("Plugin loaded", ChatColor.GREEN);

    }

    /*onDisable*/
    @Override
    public void onDisable() {
        UTils.log("Plugin unloaded", ChatColor.GREEN);
    }

    /*Initialise Config files*/
    void config() {

        /*
         * ################
         * Initialize files
         * ################
         */

        UTils.log("Initializing Configuration", ChatColor.YELLOW);

        /*
         * Check if datafolder exists
         * If not, create it
         */
        if (!this.getDataFolder().exists()) {
            try {
                UTils.log("Attempting to create Datafolder...", ChatColor.GOLD);
                if (!this.getDataFolder().mkdir()) {
                    UTils.shutdown("Can't create Datafolder");
                }
            UTils.log("Datafolder created", ChatColor.GOLD);

            }catch (Exception e) {
                UTils.shutdown("An Exception ocurred while creating the Datafolder");
            }
        }else {
            UTils.log("Datafolder exists, skipping", ChatColor.GOLD);
        }

        /*
         * Create config.yml
         */
        File config = new File(this.getDataFolder(), "config.yml");
        if (!config.exists()) {
            try {
                UTils.log("Attempting to create config.yml...", ChatColor.GOLD);
                if (!config.createNewFile()) {
                    UTils.shutdown("Can't create config.yml");
                }
                UTils.log("config.yml created", ChatColor.GOLD);
            } catch (Exception e) {
                UTils.shutdown("An Exception ocurred while creating config.yml");
            }
        }else {
            UTils.log("config.yml exists, skipping", ChatColor.GOLD);
        }

        /*
         * Create Strikes.yml
         */
        File strikes = new File(this.getDataFolder(), "strikes.yml");
        if (!strikes.exists()) {
            try {
                UTils.log("Attempting to create strikes.yml...", ChatColor.GOLD);
                if (!strikes.createNewFile()) {
                    UTils.shutdown("Can't create strikes.yml");
                }
                UTils.log("strikes.yml created", ChatColor.GOLD);
            } catch (Exception e) {
                UTils.shutdown("An Exception ocurred while creating strikes.yml");
            }
        }else {
            UTils.log("strikes.yml exists, skipping", ChatColor.GOLD);
        }

        /*
         * Create Time.yml
         */
        File time = new File(this.getDataFolder(), "time.yml");
        if (!time.exists()) {
            try {
                UTils.log("Attempting to create time.yml...", ChatColor.GOLD);
                if (!time.createNewFile()) {
                    UTils.shutdown("Can't create time.yml");
                }
                UTils.log("time.yml created", ChatColor.GOLD);
            } catch (Exception e) {
                UTils.shutdown("An Exception ocurred while creating time.yml");
            }
        }else {
            UTils.log("time.yml exists, skipping", ChatColor.GOLD);
        }

        UTils.log("Finished Initializing Configuration", ChatColor.GREEN);


        /*
         * ###############
         * Config Defaults
         * ###############
         */

        UTils.log("Initializing config nodes", ChatColor.YELLOW);

        /*
         * Defaults for config.yml
         */
        UTils.log("Initializing config.yml...", ChatColor.GOLD);
        try {
            if (!new ConfigManager(this, "config.yml").exists("maxstrikes")) {
                new ConfigManager(this, "config.yml").set("maxstrikes", 3, true);
            }

        }catch (Exception e) {
            UTils.shutdown("an Exeption occurred while initializing config nodes for config.yml");
        }
        UTils.log("config.yml initialized", ChatColor.GREEN);


        UTils.log("Finished initializing config nodes", ChatColor.GREEN);
    }

    public static StreamerVaroCore getInstance() {
        return instance;
    }
}
