package de.maxbossing.streamervaro.Events;

import de.maxbossing.streamervaro.Enums.StrikeEventType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerStrikeChangeEvent extends Event implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();

    private Player player;
    private StrikeEventType eventType;
    private int strikes;
    private boolean isCancelled;


    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    public PlayerStrikeChangeEvent(Player player, StrikeEventType eventType, int strikes) {
        this.player = player;
        this.eventType = eventType;
        this.strikes = strikes;
    }

    public Player getPlayer() {
        return this.player;
    }

    public StrikeEventType getEventType() {
        return this.eventType;
    }

    public int getStrikes(){
        return this.strikes;
    }

}
