package de.maxbossing.maxapi.UTils;

import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;

public class Locale {

    private JSONObject locale;
    private String name;

    /**
     * Create a new Locale
     * @param plugin
     * @param name
     */
    public Locale(JavaPlugin plugin, String name) throws IOException, ParseException {
        this.name = name;

        Reader inputStreamReader = new InputStreamReader(Objects.requireNonNull(plugin.getResource(this.name + ".json")));

        BufferedReader reader = new BufferedReader(inputStreamReader);
        StringBuffer sb = new StringBuffer();
        String str;

        while((str = reader.readLine())!= null){
            sb.append(str);
        }

        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject) parser.parse(str);

        this.locale = json;
    }

    /**
     * Returns the Name of the Locale
     * @return The name of the Locale e.g: de_DE
     */
    public String getName() {
        return this.name;
    }

    /**
     * Returns a String from the Locale
     * @param node the node under which the String is saved
     * @return the Locale String
     */
    public String getString(String node) {
        return  this.locale.get(node).toString();
    }
}
