package de.maxbossing.maxapi;

import de.maxbossing.maxapi.Enchantments.Glow;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.java.JavaPlugin;

import java.lang.reflect.Field;

public final class MaxAPI extends JavaPlugin {

    private static MaxAPI instance;

    private static final String VERSION = "1.1.0";

    /**
     * onEnable
     */
    @Override
    public void onEnable() {
        instance = this;
        registerEnchantments();
        Bukkit.getConsoleSender().sendMessage("[MaxAPI] MaxAPI Loaded");
    }

    /**
     * onDisable
     */
    @Override
    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage("[MaxAPI] MaxAPI Unloaded");
    }

    /**
     * Registers dummy enchantment glow which is used by the ItemStackBuilder to make items glow without adding functional enchantments
     */
    private void registerEnchantments() {
        try {
            Field f = Enchantment.class.getDeclaredField("acceptingNew");
            f.setAccessible(true);
            f.set(null, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NamespacedKey key = new NamespacedKey(this, getDescription().getName());

            Glow glow = new Glow(key);
            Enchantment.registerEnchantment(glow);
        }
        catch (IllegalArgumentException ignored){}
        catch(Exception e){
            e.printStackTrace();
        }
    }

    /**
     * returns the Main Class instance
     * @return the instance of the main class
     */
    public static MaxAPI getInstance() {
        return instance;
    }

    /**
     * returns the API Version
     * @return the API Version
     */
    public static String getVersion() {
        return VERSION;
    }

}
