package de.maxbossing.maxapi.Builders;

import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

import java.util.List;

/**
 * Banner Builder
 * @author max
 */

public class BossBarBuilder {


    private final BossBar bossBar;

    /**
     * Constructs a new BossBarBuilder with the default title "Bossbar", color {@link org.bukkit.boss.BarColor#PURPLE}, and style {@link org.bukkit.boss.BarStyle#SOLID}.
     */
    public BossBarBuilder() {
        bossBar = Bukkit.createBossBar("Bossbar", BarColor.PURPLE.PURPLE, BarStyle.SOLID);
    }

    /**
     * Sets the title of the boss bar.
     *
     * @param title the title to set
     */
    public void setTitle(String title) {
        bossBar.setTitle(title);
    }

    /**
     * Sets the color of the boss bar.
     *
     * @param color the color to set
     */
    public void setColor(BarColor color) {
        bossBar.setColor(color);
    }

    /**
     * Sets the style of the boss bar.
     *
     * @param style the style to set
     */
    public void setStyle(BarStyle style) {
        bossBar.setStyle(style);
    }

    /**
     * Sets the progress of the boss bar.
     *
     * @param progress the progress to set, from 0.0 to 1.0
     */
    public void setProgress(double progress) {
        bossBar.setProgress(progress);
    }

    /**
     * Sets the visibility of the boss bar.
     *
     * @param visible whether the boss bar should be visible or not
     */
    public void setVisible(boolean visible) {
        bossBar.setVisible(visible);
    }

    /**
     * Adds the specified player to the boss bar.
     *
     * @param player the player to add
     */
    public void addPlayer(Player player) {
        bossBar.addPlayer(player);
    }

    /**
     * Adds the specified players to the boss bar.
     *
     * @param players the players to add
     */
    public void addPlayers(Player... players) {
        for (Player player : players) {
            addPlayer(player);
        }
    }

    /**
     * Removes the specified player from the boss bar.
     *
     * @param player the player to remove
     */
    public void removePlayer(Player player) {
        bossBar.removePlayer(player);
    }

    /**
     * Removes the specified players from the boss bar.
     *
     * @param players the players to remove
     */
    public void removePlayers(Player... players) {
        for (Player player : players) {
            removePlayer(player);
        }
    }

    /**
     * Adds the specified flag to the boss bar.
     *
     * @param flag the flag to add
     */
    public void addFlag(BarFlag flag) {
        bossBar.addFlag(flag);
    }

    /**
     * Adds the specified flags to the boss bar.
     *
     * @param flags the flags to add to the boss bar
     */
    public void addFlags(BarFlag... flags) {
        for (BarFlag flag : flags) {
            bossBar.addFlag(flag);
        }
    }

    /**
     * Removes the specified flag from the boss bar.
     *
     * @param flag the flag to remove from the boss bar
     */
    public void removeFlag(BarFlag flag) {
        bossBar.removeFlag(flag);
    }

    /**
     * Removes the specified flags from the boss bar.
     *
     * @param flags the flags to remove from the boss bar
     */
    public void removeFlags(BarFlag... flags) {
        for (BarFlag flag : flags) {
            bossBar.removeFlag(flag);
        }
    }

    /**
     * Gets a list of players that can see the boss bar.
     *
     * @return a list of players that can see the boss bar
     */
    public List<Player> getPlayers() {
        return bossBar.getPlayers();
    }

    /**
     * Gets the title of the boss bar.
     *
     * @return the title of the boss bar
     */
    public String getTitle() {
        return bossBar.getTitle();
    }

    /**
     * Gets the color of the boss bar.
     *
     * @return the color of the boss bar
     */
    public BarColor getColor() {
        return bossBar.getColor();
    }

    /**
     * Gets the style of the boss bar.
     *
     * @return the style of the boss bar
     */
    public BarStyle getStyle() {
        return bossBar.getStyle();
    }

    /**
     * Gets the progress of the boss bar, from 0.0 to 1.0.
     *
     * @return the progress of the boss bar
     */
    public double getProgress() {
        return bossBar.getProgress();
    }

}