/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.UTils;

import com.google.common.base.Joiner;
import de.maxbossing.maxapi.MaxAPI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;

public class PluginUtils {
    public static void enable(Plugin plugin) {
        if (plugin != null && !plugin.isEnabled()) {
            Bukkit.getPluginManager().enablePlugin(plugin);
        }
    }

    public static void enableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            PluginUtils.enable(plugin);
        }
    }

    public static void disable(Plugin plugin) {
        if (plugin != null && plugin.isEnabled()) {
            Bukkit.getPluginManager().disablePlugin(plugin);
        }
    }

    public static void disableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            PluginUtils.disable(plugin);
        }
    }

    public static String getFormattedName(Plugin plugin) {
        return PluginUtils.getFormattedName(plugin, false);
    }

    public static String getFormattedName(Plugin plugin, boolean includeVersions) {
        ChatColor color = plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED;
        String pluginName = String.valueOf(color) + plugin.getName();
        if (includeVersions) {
            pluginName = pluginName + " (" + plugin.getDescription().getVersion() + ")";
        }
        return pluginName;
    }

    public static Plugin getPluginByName(String[] args, int start) {
        return PluginUtils.getPluginByName(PluginUtils.consolidateStrings(args, start));
    }

    public static Plugin getPluginByName(String name) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!name.equalsIgnoreCase(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    public static List<String> getPluginNames(boolean fullName) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            plugins.add(fullName ? plugin.getDescription().getFullName() : plugin.getName());
        }
        return plugins;
    }

    public static String getPluginVersion(String name) {
        Plugin plugin = PluginUtils.getPluginByName(name);
        if (plugin != null && plugin.getDescription() != null) {
            return plugin.getDescription().getVersion();
        }
        return null;
    }

    public static String getUsages(Plugin plugin) {
        ArrayList<String> parsedCommands = new ArrayList<String>();
        Map commands = plugin.getDescription().getCommands();
        if (commands != null) {
            for (Map.Entry thisEntry : commands.entrySet()) {
                if (thisEntry == null) continue;
                parsedCommands.add((String)thisEntry.getKey());
            }
        }
        if (parsedCommands.isEmpty()) {
            return "No commands registered.";
        }
        return Joiner.on((String)", ").join(parsedCommands);
    }

    public static List<String> findByCommand(String command) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            Map commands = plugin.getDescription().getCommands();
            if (commands == null) continue;
            for (Map.Entry commandNext : commands.entrySet()) {
                if (((String)commandNext.getKey()).equalsIgnoreCase(command)) {
                    plugins.add(plugin.getName());
                    continue;
                }
                for (Map.Entry attributeNext : ((Map)commandNext.getValue()).entrySet()) {
                    if (!((String)attributeNext.getKey()).equals("aliases")) continue;
                    Object aliases = attributeNext.getValue();
                    if (aliases instanceof String) {
                        if (!((String)aliases).equalsIgnoreCase(command)) continue;
                        plugins.add(plugin.getName());
                        continue;
                    }
                    List array = (List)aliases;
                    for (String str : array) {
                        if (!str.equalsIgnoreCase(command)) continue;
                        plugins.add(plugin.getName());
                    }
                }
            }
        }
        return plugins;
    }

    private static String load(Plugin plugin) {
        return PluginUtils.load(plugin.getName());
    }

    public static String load(String name) {
        Plugin target = null;
        File pluginDir = new File("mutils-addons");
        if (!pluginDir.isDirectory()) {
            return "no PluginDir there";
        }
        File pluginFile = new File(pluginDir, name + ".jar");
        if (!pluginFile.isFile()) {
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptionFile desc = MaxAPI.getInstance().getPluginLoader().getPluginDescription(f);
                    if (!desc.getName().equalsIgnoreCase(name)) continue;
                    pluginFile = f;
                    break;
                }
                catch (InvalidDescriptionException e) {
                    return "cant find";
                }
            }
        }
        try {
            target = Bukkit.getPluginManager().loadPlugin(pluginFile);
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
            return "invalid description";
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
            return "invalid Plugin";
        }
        target.onLoad();
        Bukkit.getPluginManager().enablePlugin(target);
        return "loaded";
    }

    public static void reload(Plugin plugin) {
        if (plugin != null) {
            PluginUtils.unload(plugin);
            PluginUtils.load(plugin);
        }
    }

    public static void reloadAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            PluginUtils.reload(plugin);
        }
    }

    public static String unload(Plugin plugin) {
        ClassLoader cl;
        String name = plugin.getName();
        PluginManager pluginManager = Bukkit.getPluginManager();
        SimpleCommandMap commandMap = null;
        List plugins = null;
        Map names = null;
        Map commands = null;
        Map listeners = null;
        boolean reloadlisteners = true;
        if (pluginManager != null) {
            pluginManager.disablePlugin(plugin);
            try {
                Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                pluginsField.setAccessible(true);
                plugins = (List)pluginsField.get(pluginManager);
                Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                lookupNamesField.setAccessible(true);
                names = (Map)lookupNamesField.get(pluginManager);
                try {
                    Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                    listenersField.setAccessible(true);
                    listeners = (Map)listenersField.get(pluginManager);
                }
                catch (Exception e) {
                    reloadlisteners = false;
                }
                Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                commands = (Map)knownCommandsField.get(commandMap);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                return "failed to unload";
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return "failed to unload";
            }
        }
        pluginManager.disablePlugin(plugin);
        if (plugins != null && plugins.contains(plugin)) {
            plugins.remove(plugin);
        }
        if (names != null && names.containsKey(name)) {
            names.remove(name);
        }
        if (listeners != null && reloadlisteners) {
            for (SortedSet set : listeners.values()) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    RegisteredListener value = (RegisteredListener)it.next();
                    if (value.getPlugin() != plugin) continue;
                    it.remove();
                }
            }
        }
        if (commandMap != null) {
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                c.unregister(commandMap);
                it.remove();
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(PluginUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                Logger.getLogger(PluginUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.gc();
        return "unloaded";
    }

    public static String consolidateStrings(String[] args, int start) {
        Object ret = args[start];
        if (args.length > start + 1) {
            for (int i = start + 1; i < args.length; ++i) {
                ret = (String)ret + " " + args[i];
            }
        }
        return ret;
    }
}

