/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.Builders;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullBuilder {
    private static boolean warningPosted = false;
    private static Field blockProfileField;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;

    private SkullBuilder() {
    }

    private static ItemStack createSkull() {
        SkullBuilder.checkLegacy();
        try {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        catch (IllegalArgumentException e) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
    }

    public static ItemStack createSkullByName(String name) {
        return SkullBuilder.changeSkullByName(SkullBuilder.createSkull(), name);
    }

    public static ItemStack createSkullByUUID(UUID id) {
        return SkullBuilder.changeSkullByUUID(SkullBuilder.createSkull(), id);
    }

    public static ItemStack createSkullByURL(String url) {
        return SkullBuilder.changeSkullByURL(SkullBuilder.createSkull(), url);
    }

    public static ItemStack createSkullByBase64(String base64) {
        return SkullBuilder.changeSkullByBase64(SkullBuilder.createSkull(), base64);
    }

    public static ItemStack changeSkullByName(ItemStack item, String name) {
        SkullBuilder.notNull(item, "item");
        SkullBuilder.notNull(name, "name");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner(name);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack changeSkullByUUID(ItemStack item, UUID id) {
        SkullBuilder.notNull(item, "item");
        SkullBuilder.notNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack changeSkullByURL(ItemStack item, String url) {
        SkullBuilder.notNull(item, "item");
        SkullBuilder.notNull(url, "url");
        return SkullBuilder.changeSkullByBase64(item, SkullBuilder.urlToBase64(url));
    }

    public static ItemStack changeSkullByBase64(ItemStack item, String base64) {
        SkullBuilder.notNull(item, "item");
        SkullBuilder.notNull(base64, "base64");
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        SkullBuilder.mutateItemMeta(meta, base64);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl.toString() + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static GameProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        GameProfile profile = new GameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", b64));
        return profile;
    }

    private static void mutateBlockState(Skull block, String b64) {
        try {
            if (blockProfileField == null) {
                blockProfileField = block.getClass().getDeclaredField("profile");
                blockProfileField.setAccessible(true);
            }
            blockProfileField.set(block, SkullBuilder.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void mutateItemMeta(SkullMeta meta, String b64) {
        try {
            if (metaSetProfileMethod == null) {
                metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                metaSetProfileMethod.setAccessible(true);
            }
            metaSetProfileMethod.invoke((Object)meta, SkullBuilder.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                if (metaProfileField == null) {
                    metaProfileField = meta.getClass().getDeclaredField("profile");
                    metaProfileField.setAccessible(true);
                }
                metaProfileField.set(meta, SkullBuilder.makeProfile(b64));
            }
            catch (IllegalAccessException | NoSuchFieldException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private static void checkLegacy() {
        try {
            Material.class.getDeclaredField("PLAYER_HEAD");
            Material.valueOf((String)"SKULL");
            if (!warningPosted) {
                Bukkit.getLogger().warning("SKULLCREATOR API - Using the legacy bukkit API with 1.13+ bukkit versions is not supported!");
                warningPosted = true;
            }
        }
        catch (IllegalArgumentException | NoSuchFieldException exception) {
            // empty catch block
        }
    }
}

