/*
 * Decompiled with CFR 0.152.
 */
package de.maxbossing.maxapi.Builders;

import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BannerBuilder {
    private final BannerMeta bannerMeta;
    private final ItemStack itemStack = new ItemStack(Material.LEGACY_BANNER);

    public BannerBuilder() {
        this.bannerMeta = (BannerMeta)this.itemStack.getItemMeta();
    }

    public BannerBuilder setBaseColor(DyeColor color) {
        this.bannerMeta.setBaseColor(color);
        return this;
    }

    public BannerBuilder setPattern(int index, Pattern pattern) {
        this.bannerMeta.setPattern(index, pattern);
        return this;
    }

    public BannerBuilder setPattern(int index, DyeColor color, PatternType type) {
        this.bannerMeta.setPattern(index, new Pattern(color, type));
        return this;
    }

    public BannerBuilder setPatterns(List<Pattern> patterns) {
        this.bannerMeta.setPatterns(patterns);
        return this;
    }

    public BannerBuilder addPattern(Pattern pattern) {
        this.bannerMeta.addPattern(pattern);
        return this;
    }

    public BannerBuilder addPattern(DyeColor color, PatternType type) {
        this.bannerMeta.addPattern(new Pattern(color, type));
        return this;
    }

    public BannerBuilder removePattern(int index) {
        this.bannerMeta.removePattern(index);
        return this;
    }

    public BannerBuilder removePattern() {
        for (Pattern pattern : this.bannerMeta.getPatterns()) {
            this.bannerMeta.removePattern(this.bannerMeta.getPatterns().indexOf(pattern));
        }
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta((ItemMeta)this.bannerMeta);
        return this.itemStack;
    }
}

