/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.yuicompressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorUtil;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuicompressorProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuicompressorProcessor.class);

    public boolean supportsType(Type type) {
        return type == Type.CSS;
    }

    public Resource execute(VFS vfs, final Resource resource, Map<String, Object> options) throws IOException {
        try {
            return ProcessorUtil.process((VFS)vfs, (Resource)resource, (String)"css", (ProcessorUtil.ProcessorCallback)new ProcessorUtil.ProcessorCallback(){

                public void call(Reader reader, Writer writer) throws IOException {
                    CssCompressor compressor = new CssCompressor((Reader)new StringReader(resource.getContents()));
                    int linebreakpos = -1;
                    compressor.compress(writer, -1);
                }
            });
        }
        catch (StackOverflowError e) {
            LOGGER.error("Failed to run yuicompressor on source:\n" + resource.getContents(), (Throwable)e);
            return resource;
        }
    }

    public void dispose() {
    }
}

