/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.uglifyjs;

import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorFast;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorUtil;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class UglifyjsProcessor
implements Processor {
    private final String version;
    private JavaScriptExecutor executor;
    private NodeJsExecutor node;

    public UglifyjsProcessor() {
        this("2.4.3");
    }

    public UglifyjsProcessor(String version) {
        this.version = version;
    }

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        if (this.version.startsWith("2")) {
            return this.executeWithNode(vfs, resource, options);
        }
        return this.executeWithJs(vfs, resource, options);
    }

    private Resource executeWithNode(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        VFile infile;
        if (this.node == null) {
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "uglifyjs-" + this.version);
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to setup node for uglify", (Throwable)e);
            }
        }
        if (!(infile = vfs.find(resource.getPath())).exists()) {
            throw new SmallerException("Uglify input '" + infile + "' does not exists");
        }
        String resultPath = this.node.run(vfs, resource.getPath(), options);
        VFile outfile = vfs.find('/' + resultPath);
        if (!outfile.exists()) {
            throw new SmallerException("Uglify result '" + outfile + "' does not exists");
        }
        return resource.getResolver().resolve(outfile.getPath());
    }

    private Resource executeWithJs(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        if (this.executor == null) {
            this.executor = new JavaScriptExecutorFast("uglify-" + this.version, 9, this.getClass());
            this.executor.addScriptSource("module = {};", "rhino.js");
            this.executor.addScriptFile(this.getClass().getResource("/uglify-" + this.version + "/uglify-js.js"));
            this.executor.addCallScript("uglify(%s, {});");
        }
        return ProcessorUtil.process((VFS)vfs, (Resource)resource, (String)"js", (ProcessorUtil.ProcessorCallback)new ProcessorUtil.ProcessorCallback(){

            public void call(Reader reader, Writer writer) throws IOException {
                UglifyjsProcessor.this.executor.run(reader, writer);
            }
        });
    }

    public void dispose() {
        if (this.node != null) {
            this.node.dispose();
        }
        if (this.executor != null) {
            this.executor.dispose();
        }
    }
}

