package de.matrixweb.smaller.svgo;

import java.io.IOException;
import java.util.Map;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFile;

/**
 *
 */
public class SvgoProcessor implements Processor {

  private String version;

  private NodeJsExecutor node;

  /**
   *
   */
  public SvgoProcessor() {
    this("0.3.7");
  }

  /**
   * @param version
   */
  public SvgoProcessor(String version) {
    this.version = version;
  }

  /**
   * @see de.matrixweb.smaller.resource.Processor#supportsType(de.matrixweb.smaller.resource.Type)
   */
  @Override
  public boolean supportsType(final Type type) {
    return type == Type.SVG;
  }

  /**
   * @see de.matrixweb.smaller.resource.Processor#execute(de.matrixweb.vfs.VFS,
   *      de.matrixweb.smaller.resource.Resource, java.util.Map)
   */
  @Override
  public Resource execute(final VFS vfs, final Resource resource, final Map<String, Object> options) throws IOException {
    if (this.node == null) {
      try {
        this.node = new NodeJsExecutor();
        this.node.setModule(getClass(), "svgo-" + this.version, null);
      } catch (final IOException e) {
        this.node = null;
        throw new SmallerException("Failed to setup node for svgo", e);
      }
    }
    String outfile = this.node.run(vfs, resource != null ? resource.getPath() : null, options);
    if (outfile != null) {
      final VFile file = vfs.find('/' + outfile);
      if (!file.exists()) {
        throw new SmallerException("SvgoProcessor result does not exists");
      }
    }
    return resource == null || outfile == null ? resource : resource.getResolver().resolve('/' + outfile);
  }

  /**
   * @see de.matrixweb.smaller.resource.Processor#dispose()
   */
  @Override
  public void dispose() {
    if (this.node != null) {
      this.node.dispose();
      this.node = null;
    }
  }

}
